/*
 * Decompiled with CFR 0.152.
 */
package org.pheyeji.uniteBan_Bungeecord;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.event.EventHandler;

public final class UniteBan_Bungeecord
extends Plugin
implements Listener {
    private static UniteBan_Bungeecord main;
    private static final Pattern IPV4_PATTERN;
    private static final Pattern PRIVATE_IP_PATTERN;
    private static ConcurrentHashMap<String, String> playerIpMap;
    private static String token;
    private static String PT;
    private static final HttpClient CLIENT;
    private final AtomicBoolean registrationSent = new AtomicBoolean(false);

    public void onEnable() {
        main = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!UniteBan_Bungeecord.initConfig()) {
            this.getLogger().log(Level.SEVERE, "\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25\uff0c\u63d2\u4ef6\u53ef\u80fd\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c\u3002");
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new CloudBanCommand());
        CompletableFuture.runAsync(this::sendServerRegistration);
    }

    private void sendServerRegistration() {
        if (!this.registrationSent.compareAndSet(false, true)) {
            return;
        }
        try {
            String jsonData = String.format("{\"mac\":\"%s\",\"token\":\"%s\"}", UniteBan_Bungeecord.getMacAddress(), token);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://uniteban.mcwaf.cn/innerapi.php")).header("Content-Type", "application/json").timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
            HttpResponse<String> response = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            switch (response.statusCode()) {
                case 200: {
                    UniteBan_Bungeecord.log(Level.INFO, "\u670d\u52a1\u5668\u6ce8\u518c\u4fe1\u606f\u5df2\u53d1\u9001\u81f3 UniteBan \u4e91\u7aef\u3002");
                    break;
                }
                case 403: {
                    UniteBan_Bungeecord.log(Level.WARNING, "\u670d\u52a1\u5668\u6ce8\u518c\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u4e0a\u4f20\u6743\u9650\u3002\n\n\u5982\u679c\u60a8\u4e5f\u60f3\u4e3a\u8054\u5408\u5c01\u7981\u505a\u51fa\u8d21\u732e\uff0c\u6b22\u8fce\u524d\u5f80\u7f51\u7ad9 https://uniteban.mcwaf.cn/   \u7533\u8bf7\u6743\u9650\u3002\n\n");
                    break;
                }
                default: {
                    UniteBan_Bungeecord.log(Level.SEVERE, "\u670d\u52a1\u5668\u6ce8\u518c\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.statusCode());
                    break;
                }
            }
        }
        catch (Exception e) {
            UniteBan_Bungeecord.log(Level.SEVERE, "\u53d1\u9001\u670d\u52a1\u5668\u6ce8\u518c\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent event) {
        ProxiedPlayer player = event.getPlayer();
        if (player.getPermissions().contains("uniteban.bypass")) {
            return;
        }
        String ip = this.extractIP(player.getSocketAddress().toString());
        String playerName = player.getName();
        playerIpMap.put(playerName, ip);
        UniteBan_Bungeecord.setConfig("playerdata", "\u73a9\u5bb6\u6570\u636e", playerIpMap);
        if (!this.isPrivateIP(ip)) {
            this.checkCloudBan(player);
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.updateServerPlayers();
            }
            catch (Exception e) {
                UniteBan_Bungeecord.log(Level.SEVERE, "\u66f4\u65b0\u670d\u52a1\u5668\u73a9\u5bb6\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            }
        });
    }

    private void updateServerPlayers() {
        try {
            int onlineCount = this.getProxy().getOnlineCount();
            int maxPlayers = this.getProxy().getConfig().getPlayerLimit();
            String jsonData = String.format("{\"mac\":\"%s\",\"online\":%d,\"max\":%d}", UniteBan_Bungeecord.getMacAddress(), onlineCount, maxPlayers);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://uniteban.mcwaf.cn/servers.php?action=update")).header("Content-Type", "application/json").timeout(Duration.ofSeconds(10L)).POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
            HttpResponse<String> httpResponse = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            UniteBan_Bungeecord.log(Level.SEVERE, "\u6784\u5efa\u6216\u53d1\u9001\u670d\u52a1\u5668\u73a9\u5bb6\u4fe1\u606f\u66f4\u65b0\u8bf7\u6c42\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    private String extractIP(String rawIp) {
        int colonIndex;
        if (rawIp == null) {
            return "";
        }
        if (rawIp.startsWith("/")) {
            rawIp = rawIp.substring(1);
        }
        if ((colonIndex = rawIp.lastIndexOf(58)) != -1) {
            return rawIp.substring(0, colonIndex);
        }
        return rawIp;
    }

    private boolean isPrivateIP(String ip) {
        if (ip == null || ip.isEmpty()) {
            return true;
        }
        return PRIVATE_IP_PATTERN.matcher(ip).matches() || ip.equals("::1") || ip.startsWith("fc00:") || ip.startsWith("fd00:") || ip.startsWith("fe80:");
    }

    private String generateRandomString() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 28; ++i) {
            sb.append(chars.charAt(new Random().nextInt(chars.length())));
        }
        return sb.toString();
    }

    public static boolean initConfig() {
        HashMap playerData = UniteBan_Bungeecord.getConfig("playerdata", "\u73a9\u5bb6\u6570\u636e", new HashMap());
        if (playerData instanceof Map) {
            try {
                Map castedData = playerData;
                playerIpMap = new ConcurrentHashMap(castedData);
                UniteBan_Bungeecord.getLoggerStatic().info("\u4ece playerdata.yml \u52a0\u8f7d\u4e86 " + playerIpMap.size() + " \u6761\u73a9\u5bb6\u6570\u636e\u3002");
            }
            catch (ClassCastException e) {
                UniteBan_Bungeecord.getLoggerStatic().severe("playerdata.yml \u4e2d\u7684\u6570\u636e\u65e0\u6cd5\u8f6c\u6362\u4e3a Map<String, String> \u683c\u5f0f: " + e.getMessage());
                playerIpMap = new ConcurrentHashMap();
                return false;
            }
        } else {
            UniteBan_Bungeecord.getLoggerStatic().warning("playerdata.yml \u52a0\u8f7d\u5931\u8d25\u6216\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e (\u4e0d\u662f Map \u7c7b\u578b)\uff0c\u521d\u59cb\u5316\u4e3a\u7a7a\u6620\u5c04\u3002\u52a0\u8f7d\u5230\u7684\u5bf9\u8c61: " + String.valueOf(playerData));
            playerIpMap = new ConcurrentHashMap();
        }
        token = (String)((Object)UniteBan_Bungeecord.getConfig("config", "token", "Java" + main.generateRandomString()));
        PT = UniteBan_Bungeecord.getConfig("config", "\u6d88\u606f\u524d\u7f00", "\u8054\u5408\u5c01\u7981 >>> ");
        UniteBan_Bungeecord.setConfig("config", "\u63d0\u793a", "Token \u4ec5\u5728\u7b2c\u4e00\u6b21\u4f7f\u7528\u63d2\u4ef6\u65f6\u751f\u6210,\u8bf7\u52ff\u968f\u610f\u4fee\u6539\u6570\u503c\n\u8fd9\u662f\u670d\u52a1\u5668\u7684\u552f\u4e00\u6807\u8bc6\u7801\u3002\n\u60a8\u5e94\u8be5\u59a5\u5584\u4fdd\u7ba1\u60a8\u7684 Token ,\u8bf7\u52ff\u6cc4\u9732\u7ed9\u5176\u4ed6\u4eba\u3002\n(\u7533\u8bf7\u6743\u9650\u8bf7\u5728QQ\u7fa4 152772973 \u79c1\u804a\u7fa4\u4e3b\u83b7\u53d6,\u8be6\u60c5\u8bf7\u89c1\u7fa4\u516c\u544a\u7684\u7533\u8bf7\u89c4\u5219)\n");
        return true;
    }

    public static String getMacAddress() {
        try {
            byte[] mac;
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network != null && (mac = network.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                }
                return sb.toString();
            }
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6 MAC \u5730\u5740");
        }
        catch (Exception e) {
            UniteBan_Bungeecord.log(Level.SEVERE, "\u83b7\u53d6MAC\u5730\u5740\u5931\u8d25: " + e.getMessage());
            return "00:00:00:00:00:00";
        }
    }

    public boolean updateToCloudBlackList(String player, String reason, boolean sendSuccessMeg) {
        String playerIp = playerIpMap.get(player);
        if (playerIp == null) {
            this.getLogger().warning("\u5c1d\u8bd5\u4e0a\u4f20\u73a9\u5bb6 " + player + " \u5230\u4e91\u9ed1\u65f6\uff0c\u672a\u5728\u672c\u5730\u7f13\u5b58\u4e2d\u627e\u5230\u5176 IP \u5730\u5740\u3002\u5c06\u4f7f\u7528\u7a7a\u5b57\u7b26\u4e32\u4e0a\u4f20\u3002");
            playerIp = "";
        }
        String finalPlayerIp = playerIp;
        CompletableFuture.runAsync(() -> {
            try {
                HttpResponse<String> response = UniteBan_Bungeecord.getHttpURLResponse(String.format("{\"name\":\"%s\",\"ip\":\"%s\",\"mac\":\"%s\",\"token\":\"%s\",\"reason\":\"%s\"}", player, finalPlayerIp, UniteBan_Bungeecord.getMacAddress(), token, reason), "https://uniteban.mcwaf.cn/innerapi.php");
                switch (response.statusCode()) {
                    case 200: {
                        if (sendSuccessMeg) {
                            this.getProxy().broadcast((BaseComponent)new TextComponent(PT + "\u73a9\u5bb6 " + player + " \u5df2\u6210\u529f\u52a0\u5165\u4e91\u9ed1\u5217\u8868\n\u539f\u56e0: " + reason));
                        }
                        break;
                    }
                    case 403: {
                        UniteBan_Bungeecord.log(Level.WARNING, "\u4e0a\u4f20\u5931\u8d25, \u672a\u83b7\u53d6\u4e0a\u4f20\u6743\u9650\n\n\u00a7e\u5982\u679c\u60a8\u4e5f\u60f3\u4e3a\u8054\u5408\u5c01\u7981\u505a\u51fa\u8d21\u732e, \u6b22\u8fce\u524d\u5f80\u7f51\u7ad9\u00a76 https://uniteban.mcwaf.cn/     \u00a7e\u7533\u8bf7\u6743\u9650\n\n");
                        break;
                    }
                    default: {
                        UniteBan_Bungeecord.log(Level.SEVERE, "\u4e0a\u4f20\u5931\u8d25: \u72b6\u6001\u7801 " + response.statusCode() + ", \u54cd\u5e94\u4f53: " + response.body());
                        break;
                    }
                }
            }
            catch (Exception e) {
                UniteBan_Bungeecord.log(Level.SEVERE, "\u8bf7\u6c42\u5f02\u5e38 (\u6dfb\u52a0\u4e91\u9ed1): " + String.valueOf(e));
            }
        });
        return true;
    }

    private void checkCloudBan(ProxiedPlayer player) {
        CompletableFuture.runAsync(() -> {
            try {
                String playerIp = playerIpMap.get(player.getName());
                HttpResponse<String> response = UniteBan_Bungeecord.getHttpURLResponse(String.format("{\"name\":\"%s\",\"ip\":\"%s\"}", player.getName(), playerIp != null ? playerIp : ""), "https://uniteban.mcwaf.cn/api.php");
                int status = response.statusCode();
                if (status == 200) {
                    if (response.body().contains("\"exists\":true")) {
                        int reasonEnd;
                        String reason = "\u8fdd\u89c4\u884c\u4e3a";
                        String responseBody = response.body();
                        int reasonStart = responseBody.indexOf("\"reason\":\"");
                        if (reasonStart != -1 && (reasonEnd = responseBody.indexOf("\"", reasonStart += 10)) != -1) {
                            reason = responseBody.substring(reasonStart, reasonEnd);
                        }
                        UniteBan_Bungeecord.log(Level.INFO, "\u73a9\u5bb6 " + player.getName() + " \u8054\u5408\u5c01\u7981 - \u68c0\u67e5\u672a\u901a\u8fc7, \u539f\u56e0: " + reason);
                        player.disconnect((BaseComponent)new TextComponent("\u00a7c\u8054\u5408\u5c01\u7981 - \u68c0\u67e5\u672a\u901a\u8fc7\n\u539f\u56e0: " + reason + "\n\u7533\u8bc9\u5730\u5740\nhttps://uniteban.mcwaf.cn/appeal/    "));
                    }
                } else {
                    UniteBan_Bungeecord.log(Level.SEVERE, "\u68c0\u67e5\u5931\u8d25,\u72b6\u6001\u7801: " + status + ", \u54cd\u5e94\u4f53: " + response.body());
                }
            }
            catch (Exception e) {
                UniteBan_Bungeecord.log(Level.SEVERE, "\u5c01\u7981\u68c0\u67e5\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage());
            }
        });
    }

    private static HttpResponse<String> getHttpURLResponse(String postData, String Url) throws Exception {
        String correctedUrl = Url.trim();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(correctedUrl)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofString(postData)).build();
        return CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
    }

    private static Logger getLoggerStatic() {
        if (main != null) {
            return main.getLogger();
        }
        return Logger.getLogger(UniteBan_Bungeecord.class.getName());
    }

    private static void log(Level level, String msg) {
        if (main != null) {
            main.getLogger().log(level, msg);
        } else {
            Logger.getLogger(UniteBan_Bungeecord.class.getName()).log(level, msg);
        }
    }

    private static <T> T getConfig(String path, String name, T defaultValue) {
        try {
            Configuration config;
            Object value;
            File file = new File(main.getDataFolder(), path + ".yml");
            if (!file.exists()) {
                try {
                    InputStream is = main.getResourceAsStream(path + ".yml");
                    if (is == null) {
                        file.createNewFile();
                        Configuration config2 = new Configuration();
                        config2.set(name, defaultValue);
                        ConfigurationProvider.getProvider(YamlConfiguration.class).save(config2, file);
                        return defaultValue;
                    }
                    Files.copy(is, file.toPath(), new CopyOption[0]);
                }
                catch (Exception e) {
                    UniteBan_Bungeecord.log(Level.SEVERE, "\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
                    return defaultValue;
                }
            }
            if ((value = (config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file)).get(name)) == null) {
                config.set(name, defaultValue);
                ConfigurationProvider.getProvider(YamlConfiguration.class).save(config, file);
                return defaultValue;
            }
            if (defaultValue instanceof Map && value instanceof Configuration) {
                Configuration cfgValue = (Configuration)value;
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (String key : cfgValue.getKeys()) {
                    resultMap.put(key, cfgValue.get(key));
                }
                if (!resultMap.isEmpty() && resultMap.values().iterator().next() instanceof String) {
                    HashMap<String, String> stringMap = new HashMap<String, String>();
                    for (Map.Entry entry : resultMap.entrySet()) {
                        stringMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    return (T)stringMap;
                }
                return (T)resultMap;
            }
            return (T)value;
        }
        catch (Exception e) {
            UniteBan_Bungeecord.log(Level.SEVERE, "\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
            return defaultValue;
        }
    }

    private static void setConfig(String path, String name, Object value) {
        try {
            File file = new File(main.getDataFolder(), path + ".yml");
            Configuration config = file.exists() ? ConfigurationProvider.getProvider(YamlConfiguration.class).load(file) : new Configuration();
            config.set(name, value);
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(config, file);
        }
        catch (IOException e) {
            UniteBan_Bungeecord.log(Level.SEVERE, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    static {
        IPV4_PATTERN = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
        PRIVATE_IP_PATTERN = Pattern.compile("^(127\\.0\\.0\\.1)|(10\\..*)|(172\\.1[6-9]\\..*)|(172\\.2[0-9]\\..*)|(172\\.3[0-1]\\..*)|(192\\.168\\..*)");
        playerIpMap = new ConcurrentHashMap();
        CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    private class CloudBanCommand
    extends Command {
        public CloudBanCommand() {
            super("cloudban", "uniteban.command", new String[0]);
        }

        public void execute(CommandSender sender, String[] args) {
            if (args.length < 1) {
                sender.sendMessage((BaseComponent)new TextComponent(PT + "\u7528\u6cd5: /cloudban <\u73a9\u5bb6\u540d> <\u539f\u56e0>"));
                if (UniteBan_Bungeecord.initConfig()) {
                    sender.sendMessage((BaseComponent)new TextComponent(PT + "\u914d\u7f6e\u91cd\u8f7d\u6210\u529f"));
                } else {
                    sender.sendMessage((BaseComponent)new TextComponent(PT + "\u914d\u7f6e\u91cd\u8f7d\u5931\u8d25"));
                }
                return;
            }
            if (args.length < 2) {
                sender.sendMessage((BaseComponent)new TextComponent(PT + "\u7528\u6cd5: /cloudban <\u73a9\u5bb6\u540d> <\u539f\u56e0>"));
                return;
            }
            String playerName = args[0];
            StringBuilder reasonBuilder = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                reasonBuilder.append(args[i]);
                if (i >= args.length - 1) continue;
                reasonBuilder.append(" ");
            }
            String reason = reasonBuilder.toString();
            if (UniteBan_Bungeecord.this.updateToCloudBlackList(playerName, reason, false)) {
                sender.sendMessage((BaseComponent)new TextComponent(PT + "\u73a9\u5bb6 " + playerName + " \u5df2\u6dfb\u52a0\u5230\u4e91\u7aef\u5c01\u7981\n\u539f\u56e0: " + reason));
                ProxiedPlayer targetPlayer = UniteBan_Bungeecord.this.getProxy().getPlayer(playerName);
                if (targetPlayer != null) {
                    targetPlayer.disconnect((BaseComponent)new TextComponent("\u00a7c\u8054\u5408\u5c01\u7981 - \u88ab\u624b\u52a8\u5c01\u7981\n\u539f\u56e0: " + reason + "\n\u7533\u8bc9\u5730\u5740\nhttps://uniteban.mcwaf.cn/appeal/    "));
                    UniteBan_Bungeecord.this.getProxy().broadcast((BaseComponent)new TextComponent(PT + "\u73a9\u5bb6 " + playerName + " \u88ab\u624b\u52a8\u5c01\u7981\n\u539f\u56e0: " + reason));
                }
            } else {
                sender.sendMessage((BaseComponent)new TextComponent(PT + "\u4e0a\u4f20\u5c01\u7981\u4fe1\u606f\u5931\u8d25"));
            }
        }
    }
}

