// LiteLoader-AIDS automatic generated
/// <reference path="c:\Users\Administrator\.vscode\extensions\moxicat.llscripthelper-2.2.0\origin/dts/helperlib/src/index.d.ts"/> 

ll.registerPlugin(
    /* name */
    "UniteBan",
    /* introduction */
    "联合封禁",
    /* version */
    [0, 0, 1],
    /* otherInformation */
    {
        "author": "PHEyeji"
    }
);

let conf = new JsonConfigFile("./plugins/UniteBan/config.json")

let whitelist = new JsonConfigFile("./plugins/UniteBan/whitelist.json")
whitelist.init("IP", ["127.0.0.1", "0.0.0.0"])
whitelist.init("PlayerName", ["Steve", "Alex"])

conf.init("autoupdate", true)
conf.init("kickplayer", true)
conf.init("transplayer", false)

let playerdata = new JsonConfigFile("./plugins/UniteBan/datas/playerdata.json")
let autoupdate = new JsonConfigFile("./plugins/UniteBan/datas/autoupdate.json")
let banCacheFile = new JsonConfigFile("./plugins/UniteBan/datas/bancache.json");
banCacheFile.init("cache", {});
let maxplayers = 10;

const PRIMARY_DOMAIN = "https://uniteban.mcwaf.cn";
const FALLBACK_IP = "http://103.217.186.175";

/**
 * 带 fallback 的 HTTP POST 请求
 * @param {string} primaryPath - 主域名后的路径，如 "/api.php"
 * @param {string} fallbackPath - 备用 IP 后的路径，应与 primaryPath 一致
 * @param {string} jsonData - POST 数据
 * @param {string} contentType - 内容类型
 * @param {function} finalCallback - (status, result) => void
 */
function httpPostWithFallback(primaryPath, fallbackPath, jsonData, contentType, finalCallback) {
    let retryCount = 0;
    const maxRetries = 3;

    function tryPrimary() {
        network.httpPost(
            PRIMARY_DOMAIN + primaryPath,
            jsonData,
            contentType,
            (status, result) => {
                if (status === 200) {
                    finalCallback(status, result);
                } else {
                    retryCount++;
                    if (retryCount < maxRetries) {
                        tryPrimary();
                    } else {
                        // 尝试 fallback 一次
                        network.httpPost(
                            FALLBACK_IP + fallbackPath,
                            jsonData,
                            contentType,
                            (fbStatus, fbResult) => {
                                finalCallback(fbStatus, fbResult);
                            }
                        );
                    }
                }
            }
        );
    }

    tryPrimary();
}

/**
 * 带 fallback 的 HTTP GET 请求
 * @param {string} primaryPath
 * @param {string} fallbackPath
 * @param {function} finalCallback
 */
function httpGetWithFallback(primaryPath, fallbackPath, finalCallback) {
    let retryCount = 0;
    const maxRetries = 3;

    function tryPrimary() {
        network.httpGet(
            PRIMARY_DOMAIN + primaryPath,
            (status, result) => {
                if (status === 200) {
                    finalCallback(status, result);
                } else {
                    retryCount++;
                    if (retryCount < maxRetries) {
                        tryPrimary();
                    } else {
                        network.httpGet(
                            FALLBACK_IP + fallbackPath,
                            (fbStatus, fbResult) => {
                                finalCallback(fbStatus, fbResult);
                            }
                        );
                    }
                }
            }
        );
    }

    tryPrimary();
}

/**
 * 从server.properties读取max-players值
 */
function fetchmaxplayersSetting() {
    try {
        const configData = file.readFrom("./server.properties");
        if (configData) {
            const configLines = configData.split("\n");
            for (const line of configLines) {
                if (line.trim().startsWith("max-players=")) {
                    const rawValue = line.split("=")[1];
                    const numericValue = parseInt(rawValue, 10);
                    if (!isNaN(numericValue)) {
                        logger.info(`成功解析 max-players 参数：${numericValue}`);
                        return numericValue;
                    }
                }
            }
        }
    } catch (error) {
        logger.error(`加载配置文件时出错：${error.message}`);
    }
    return 4;
}

maxplayers = fetchmaxplayersSetting();

let portV4 = 19132;
function fetchServerPortSetting() {
    try {
        const configData = file.readFrom("./server.properties");
        if (configData) {
            const configLines = configData.split("\n");
            for (const line of configLines) {
                const trimmedLine = line.trim();
                if (trimmedLine === "" || trimmedLine.startsWith("#")) continue;
                if (trimmedLine.startsWith("server-port=")) {
                    const rawValue = trimmedLine.split("=")[1].trim();
                    const numericValue = parseInt(rawValue, 10);
                    if (!isNaN(numericValue) && numericValue > 0 && numericValue <= 65535) {
                        logger.info(`成功解析 server-port 参数：${numericValue}`);
                        return numericValue;
                    } else {
                        logger.warn(`server-port 的值无效：${rawValue}`);
                    }
                }
            }
        }
    } catch (error) {
        logger.error(`加载配置文件时出错：${error.message}`);
    }
    logger.info("未找到有效的 server-port 配置，使用默认端口 19132");
    return 19132;
}

portV4 = fetchServerPortSetting();

function updateserverplayers() {
    try {
        let mac = macCache;
        if (!mac) return;
        let online = mc.getOnlinePlayers().length;

        if (maxplayers < online) {
            maxplayers = online + 1;
        }

        const postdata = {
            ...(mac != null && { mac: mac }),
            ...(online != null && { online: online }),
            ...(maxplayers != null && { max: maxplayers }),
            ...(portV4 != null && { portV4: portV4 })
        };

        const jsonData = JSON.stringify(postdata);
        httpPostWithFallback(
            "/servers.php?action=update",
            "/servers.php?action=update",
            jsonData,
            "application/json",
            (status, result) => {
                if (status !== 200) {
                    logger.warn("服务器状态上报失败（含 fallback）");
                }
            }
        );
    } catch (error) {
        logger.error(`Error in updateserverplayers: ${error.message}`);
    }
}

mc.listen("onJoin", (player) => {
    try {
        if (player.isSimulatedPlayer()) return;

        let rawIp = player.getDevice().ip;
        let ip;

        if (rawIp.includes('|')) {
            ip = rawIp.split('|')[0];
        } else if (rawIp.startsWith('[')) {
            const endBracket = rawIp.indexOf(']');
            if (endBracket !== -1) {
                ip = rawIp.substring(1, endBracket);
            } else {
                ip = rawIp;
            }
        } else {
            const lastColon = rawIp.lastIndexOf(':');
            if (lastColon !== -1) {
                const afterColon = rawIp.substring(lastColon + 1);
                if (/^\d+$/.test(afterColon)) {
                    ip = rawIp.substring(0, lastColon);
                } else {
                    ip = rawIp;
                }
            } else {
                ip = rawIp;
            }
        }

        let pldata = [{
            "xuid": player.xuid,
            "uuid": player.uuid,
            "clientid": player.getDevice().clientId || null
        }];

        if (ip && !isPrivateIP(String(ip))) {
            pldata[0].ip = ip;
        }

        playerdata.set(player.realName, pldata);

        checkcloudban(player.realName, player.xuid, player.uuid, player.getDevice().clientId, ip);
        updateserverplayers();

    } catch (error) {
        logger.error(`Error in onJoin listener: ${error.message}`);
    }
});

let cmd = mc.newCommand("cloudban", "封禁玩家", PermType.GameMasters);
cmd.mandatory("name", ParamType.String);
cmd.mandatory("reason", ParamType.String);
cmd.overload(["name", "reason"]);
cmd.setCallback((cmd, ori, out, res) => {
    let name = res.name;
    let pldata = playerdata.get(name);
    let mac = macCache;

    function doBan(xuid, uuid, clientid, ip) {
        out.success("正在上传数据...");
        updateinfo(name, xuid, uuid, clientid, ip, mac, res.reason);

        // const msg = name + "联合封禁UniteBan检查不通过\n封禁原因:" + res.reason + "\n申诉地址\n  https://uniteban.mcwaf.cn/appeal/    ";
        // let player = mc.getPlayer(name);
        // if (player) {
        //     if (conf.get("transplayer")) {
        //         player.transServer("175.27.133.111", 19132);
        //     }
        //     if (conf.get("kickplayer")) {
        //         setTimeout(() => player.kick(msg), 1000);
        //     }
        //     mc.broadcast(msg);
        // }
    }

    if (!pldata) {
        let uuid = data.name2uuid(name);
        let xuid = data.name2xuid(name);
        if (uuid == null && xuid == null) {
            out.error("玩家尚未进入过服务器");
        } else {
            doBan(xuid, uuid, null, null);
        }
    } else {
        pldata = pldata[0];
        doBan(pldata.xuid, pldata.uuid, pldata.clientid, pldata.ip);
    }
});
cmd.setup();

/**
 * 检查玩家是否被联合封禁（带乐观缓存）
 */
function checkcloudban(realname, xuid, uuid, clientid, ip) {
    try {
        whitelist.reload();
        let whitename = Array.from(whitelist.get("PlayerName"));
        let whiteip = Array.from(whitelist.get("IP"));

        if (ip != undefined && whiteip.includes(ip)) {
            logger.log(`玩家 ${realname} 的 IP地址 处于 白名单 中，跳过IP检查`);
            ip = null;
        }

        if (realname != undefined && whitename.includes(realname)) {
            logger.log(`玩家 ${realname} 的 玩家名 处于 白名单 中，跳过检查`);
            return;
        }

        // 尝试从缓存读取（仅用于 fallback）
        const cached = banCacheFile.get("cache")[realname];

        const postdata = {
            ...(realname != null && { name: realname }),
            ...(xuid != null && { xuid: xuid }),
            ...(uuid != null && { uuid: uuid }),
            ...(clientid != null && { clientid: clientid }),
            ...(ip != null && { ip: ip })
        };
        const jsonData = JSON.stringify(postdata);

        httpPostWithFallback(
            "/api.php",
            "/api.php",
            data.toBase64(jsonData),
            "application/json",
            (status, result) => {
                try {
                    if (status === 200) {
                        const response = JSON.parse(result);
                        // ✅ API 成功：更新缓存
                        const cacheObj = banCacheFile.get("cache");
                        cacheObj[realname] = {
                            exists: response.exists,
                            reason: response.reason || ""
                        };
                        banCacheFile.set("cache", cacheObj);

                        if (response.exists === true) {
                            logger.warn(`玩家 ${realname} 联合封禁UniteBan检查不通过`);
                            logger.warn("封禁原因:" + response.reason);

                            let mac = macCache || "unknown";
                            updateinfo(realname, xuid, uuid, clientid, ip, mac, response.reason);

                            const pl = mc.getPlayer(realname);
                            if (pl) {
                                if (conf.get("transplayer")) {
                                    pl.transServer("175.27.133.111", 19132);
                                }
                                const msg = pl.realName + `联合封禁UniteBan检查不通过\n封禁原因: ${response.reason}\n申诉地址:\nhttps://uniteban.mcwaf.cn/appeal/`;
                                if (conf.get("kickplayer")) pl.kick(msg);
                                mc.broadcast(msg);
                            }
                        } else {
                            logger.log(`玩家 ${realname} 联合封禁UniteBan检查通过`);
                        }
                    } else {
                        // ❌ 所有网络请求失败：回退到缓存
                        logger.warn(`玩家 ${realname} 联合封禁检查失败（含 fallback），使用缓存...`);
                        if (cached && cached.exists === true) {
                            logger.warn(`（缓存）玩家 ${realname} 被联合封禁`);
                            logger.warn("（缓存）封禁原因: " + cached.reason);

                            const pl = mc.getPlayer(realname);
                            if (pl) {
                                if (conf.get("transplayer")) {
                                    pl.transServer("175.27.133.111", 19132);
                                }
                                const msg = pl.realName + `联合封禁UniteBan检查不通过（缓存）\n封禁原因: ${cached.reason}\n申诉地址:\nhttps://uniteban.mcwaf.cn/appeal/`;
                                if (conf.get("kickplayer")) pl.kick(msg);
                                mc.broadcast(msg);
                            }
                        } else {
                            logger.log(`（缓存）玩家 ${realname} 未被封禁或无缓存记录，允许进入`);
                        }
                    }
                } catch (e) {
                    logger.error(`响应解析失败: ${e.message}`);
                    // 即使解析失败，也尝试用缓存兜底
                    if (cached && cached.exists === true) {
                        const pl = mc.getPlayer(realname);
                        if (pl) {
                            const msg = pl.realName + `联合封禁检查异常（使用缓存）\n封禁原因: ${cached.reason}\n申诉地址:\nhttps://uniteban.mcwaf.cn/appeal/`;
                            if (conf.get("kickplayer")) pl.kick(msg);
                            mc.broadcast(msg);
                        }
                    }
                }
            }
        );
    } catch (error) {
        logger.error(`Error in checkcloudban: ${error.message}`);
        // 极端情况：直接查缓存
        const cached = banCacheFile.get("cache")[realname];
        if (cached && cached.exists === true) {
            const pl = mc.getPlayer(realname);
            if (pl) {
                const msg = pl.realName + `联合封禁检查异常（缓存兜底）\n封禁原因: ${cached.reason}\n申诉地址:\nhttps://uniteban.mcwaf.cn/appeal/`;
                if (conf.get("kickplayer")) pl.kick(msg);
                mc.broadcast(msg);
            }
        }
    }
}

function stringToMac(input) {
    function customHash(str) {
        const prime = 16777619;
        let hash = 2166136261;
        for (let i = 0; i < str.length; i++) {
            hash ^= str.charCodeAt(i);
            hash += (hash << 1) + (hash << 4) + (hash << 7) + (hash << 8) + (hash << 24);
            hash = hash >>> 0;
        }
        const part1 = (hash * prime) >>> 0;
        const part2 = (hash + part1 * prime) >>> 0;
        const part3 = (part1 + part2 * prime) >>> 0;
        const part4 = (part2 + part3 * prime) >>> 0;
        return [
            (part1 & 0xFF), (part1 >>> 8) & 0xFF, (part1 >>> 16) & 0xFF, (part1 >>> 24) & 0xFF,
            (part2 & 0xFF), (part2 >>> 8) & 0xFF, (part2 >>> 16) & 0xFF, (part2 >>> 24) & 0xFF,
            (part3 & 0xFF), (part3 >>> 8) & 0xFF, (part3 >>> 16) & 0xFF, (part3 >>> 24) & 0xFF,
            (part4 & 0xFF), (part4 >>> 8) & 0xFF, (part4 >>> 16) & 0xFF, (part4 >>> 24) & 0xFF
        ];
    }
    const hashBytes = customHash(input);
    const macBytes = [hashBytes[0], hashBytes[1], hashBytes[2], hashBytes[3], hashBytes[4], hashBytes[5]];
    macBytes[0] = (macBytes[0] & 0xFE) | 0x02;
    return macBytes.map(b => b.toString(16).padStart(2, '0').toUpperCase()).join(':');
}

let macCache = null;

async function getMacAddress() {
    if (macCache) return macCache;

    const methods = [
        async () => {
            const iface = await executeCmd(`ip route show default | awk '{print $5}'`);
            if (!iface) throw new Error();
            return executeCmd(`cat /sys/class/net/${iface}/address`);
        },
        async () => {
            const iface = await executeCmd(`ip route show default | awk '{print $5}'`);
            return executeCmd(`ip link show ${iface} | awk '/link\\/ether/{print $2}'`);
        },
        async () => {
            const iface = await executeCmd(`ip route show default | awk '{print $5}'`);
            return executeCmd(`ifconfig ${iface} | awk '/ether/{print $2}'`);
        },
        async () => executeCmd(`networksetup -getmacaddress en0 | awk '{print $3}'`),
        async () => executeCmd(`ifconfig en0 | awk '/ether/{print $2}'`),
        async () => executeCmd(`system_profiler SPNetworkDataType | awk '/MAC Address/{print $3}'`),
        async () => {
            const output = await executeCmd("getmac");
            return output.match(/([0-9A-F]{2}[:-]){5}[0-9A-F]{2}/i)?.[0];
        },
        async () => {
            const output = await executeCmd("ipconfig /all");
            return output.match(/Physical Address[.:].*?([0-9A-F-]{17})/i)?.[1];
        }
    ];

    for (const method of methods) {
        try {
            const mac = await method();
            if (mac) {
                macCache = formatMac(mac.trim());
                return macCache;
            }
        } catch (e) { }
    }

    let mac = stringToMac(tokenconf.get("token"));
    macCache = mac;
    return macCache;
}

function executeCmd(command) {
    return new Promise((resolve, reject) => {
        system.cmd(command, (exitcode, output) => {
            exitcode === 0 ? resolve(output) : reject(new Error(`Command failed: ${command}`));
        });
    });
}

function formatMac(mac) {
    return mac.toUpperCase().replace(/-/g, ":").replace(/\./g, ":");
}

function generateRandomString(length) {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    let result = '';
    for (let i = 0; i < length; i++) {
        const randomIndex = Math.floor(Math.random() * chars.length);
        result += chars[randomIndex];
    }
    return result;
}

let tokenconf = new JsonConfigFile("./plugins/UniteBan/Token.json");
tokenconf.init("token", String(generateRandomString(32)));

mc.listen("onServerStarted", async () => {
    if (conf.get("autoupdate")) {
        autoupdate.init("reload", 0);

        httpGetWithFallback(
            "/download/file/UniteBan.js",
            "/download/file/UniteBan.js",
            (st2, dat2) => {
                if (st2 == 200) {
                    let new_plugin_raw = dat2.replace(/\r/g, '');
                    file.writeTo("./plugins/UniteBan/UniteBan.js", new_plugin_raw);
                    if (autoupdate.get("reload") == 0) {
                        colorLog("yellow", "自动更新中...");
                        autoupdate.set("reload", 1);
                        unitebanreload();
                    } else {
                        autoupdate.set("reload", 0);
                    }
                } else {
                    logger.warn("检测新版本失败（含 fallback）");
                }
            }
        );
    }

    try {
        let mac = await getMacAddress();
        colorLog("yellow", mac);
        updateinfo(null, null, null, null, null, mac, null);
        
        colorLog("yellow", "联合封禁 — https://uniteban.mcwaf.cn/  ");
    } catch (error) {
        logger.error(`Error in onServerStarted: ${error.message}`);
    }
});

function unitebanreload() {
    mc.runcmd("ll reload UniteBan");
    return true;
}

function updateinfo(realname = null, xuid = null, uuid = null, clientid = null, ip = null, mac, reason = null) {
    try {
        if (mac == null || mac === "") return;

        whitelist.reload()
        let whitename = Array.from(whitelist.get("PlayerName"))
        let whiteip = Array.from(whitelist.get("IP"))
        if (ip != undefined && whiteip.includes(ip)) {
            setTimeout(() => {
                logger.log(`玩家 ${realname} 的 IP地址 处于 白名单 中，跳过 IP要素`)
            }, 1000);
            ip = null
        }

        if (realname != undefined && whitename.includes(realname)) {
            setTimeout(() => {
                logger.log(`玩家 ${realname} 的 玩家名 处于 白名单 中，无法上传`)
            }, 1000);
            return
        }

        const postdata = {};
        if (realname != null) postdata.name = realname;
        if (xuid != null) postdata.xuid = xuid;
        if (uuid != null) postdata.uuid = uuid;
        if (clientid != null) postdata.clientid = clientid;
        if (ip != null) postdata.ip = ip;
        if (mac != null) postdata.mac = mac;
        if (tokenconf.get("token") != null) postdata.token = tokenconf.get("token");
        if (reason != null) postdata.reason = reason;

        if (Object.keys(postdata).length === 0) return;

        const jsonData = JSON.stringify(postdata);
        httpPostWithFallback(
            "/innerapi.php",
            "/innerapi.php",
            data.toBase64(jsonData),
            "application/json",
            (status, result) => {
                try {
                    if (status === 200) {
                        const response = JSON.parse(result);
                        if (response.status === "success") {
                            logger.log(`玩家 ${realname} 数据已上传至联合封禁云端`);

                            const msg = realname + "联合封禁UniteBan检查不通过\n封禁原因:" + reason + "\n申诉地址\n  https://uniteban.mcwaf.cn/appeal/    ";
                            let player = mc.getPlayer(realname);
                            if (player) {
                                if (conf.get("transplayer")) {
                                    player.transServer("175.27.133.111", 19132);
                                }
                                if (conf.get("kickplayer")) {
                                    setTimeout(() => player.kick(msg), 1000);
                                }
                                mc.broadcast(msg);
                            }

                        }
                    } else {
                        logger.error(`如果您也想为联合封禁做出贡献，欢迎前往网站 https://uniteban.mcwaf.cn/   申请权限`);
                    }
                } catch (e) { }
            }
        );
    } catch (error) {
        logger.error(`Error in updateinfo: ${error.message}`);
    }
}

// --- IP 工具函数（保持不变）---
function isPrivateIP(ip) {
    if (ip.includes('.')) return isPrivateIPv4(ip);
    if (ip.includes(':')) return isPrivateIPv6(ip);
    return false;
}

function isPrivateIPv4(ip) {
    var parts = ip.split('.');
    if (parts.length !== 4) return false;
    var n0 = parseInt(parts[0], 10);
    var n1 = parseInt(parts[1], 10);
    var n2 = parseInt(parts[2], 10);
    var n3 = parseInt(parts[3], 10);
    if (isNaN(n0) || n0 < 0 || n0 > 255 ||
        isNaN(n1) || n1 < 0 || n1 > 255 ||
        isNaN(n2) || n2 < 0 || n2 > 255 ||
        isNaN(n3) || n3 < 0 || n3 > 255) {
        return false;
    }
    if (n0 === 10) return true;
    if (n0 === 172 && n1 >= 16 && n1 <= 31) return true;
    if (n0 === 192 && n1 === 168) return true;
    if (n0 === 169 && n1 === 254) return true;
    if (n0 === 127) return true;
    return false;
}

function isPrivateIPv6(ip) {
    var parts = expandIPv6(ip);
    if (!parts || parts.length !== 8) return false;
    if (parts[0] === 0 && parts[1] === 0 && parts[2] === 0 && parts[3] === 0 &&
        parts[4] === 0 && parts[5] === 0 && parts[6] === 0 && parts[7] === 1) {
        return true;
    }
    var firstPart = parts[0];
    if (firstPart >= 0xfc00 && firstPart <= 0xfdff) return true;
    if (firstPart >= 0xfe80 && firstPart <= 0xfebf) return true;
    return false;
}

function expandIPv6(ip) {
    var parts = ip.split(':');
    var result = [];
    var skipIndex = -1;
    for (var i = 0; i < parts.length; i++) {
        if (parts[i] === '') {
            skipIndex = i;
            break;
        }
    }
    if (skipIndex >= 0) {
        var before = parts.slice(0, skipIndex);
        var after = parts.slice(skipIndex + 1);
        var fillLength = 8 - (before.length + after.length);
        for (i = 0; i < before.length; i++) result.push(before[i]);
        for (i = 0; i < fillLength; i++) result.push('0');
        for (i = 0; i < after.length; i++) result.push(after[i]);
    } else {
        result = parts;
    }
    if (result.length !== 8) return null;
    var intParts = [];
    for (i = 0; i < 8; i++) {
        if (result[i] === '') {
            intParts.push(0);
        } else {
            var intVal = parseInt(result[i], 16);
            if (isNaN(intVal)) return null;
            intParts.push(intVal);
        }
    }
    return intParts;
}