/*
 * Decompiled with CFR 0.152.
 */
package org.uniteban.uniteban;

import com.google.inject.Inject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Plugin(id="uniteban", name="UniteBan", version="1.0.0")
public class Uniteban {
    private static Uniteban main;
    private static final Pattern IPV4_PATTERN;
    private static final Pattern PRIVATE_IP_PATTERN;
    private static ConcurrentHashMap<String, String> playerIpMap;
    private static String token;
    private static String PT;
    private static final HttpClient CLIENT;
    private final AtomicBoolean registrationSent = new AtomicBoolean(false);
    private final ProxyServer server;
    private static Logger logger;
    private final Path dataDirectory;

    @Inject
    public Uniteban(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        Uniteban.logger = logger;
        this.dataDirectory = dataDirectory;
        main = this;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u6570\u636e\u6587\u4ef6\u5939\u5931\u8d25: " + e.getMessage());
                return;
            }
        }
        this.createDefaultConfigs();
        if (!this.initConfig()) {
            logger.error("\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25\uff0c\u63d2\u4ef6\u53ef\u80fd\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c\u3002");
            return;
        }
        try {
            this.server.getCommandManager().register(this.createCloudBanCommand());
        }
        catch (Exception e) {
            logger.error("\u6ce8\u518c\u547d\u4ee4\u5931\u8d25: " + e.getMessage());
        }
        CompletableFuture.runAsync(this::sendServerRegistration);
        logger.info("UniteBan \u63d2\u4ef6\u5df2\u6210\u529f\u52a0\u8f7d!");
    }

    private void createDefaultConfigs() {
        File playerDataFile;
        Yaml yaml;
        DumperOptions options;
        File configFile = new File(this.dataDirectory.toFile(), "config.yml");
        if (!configFile.exists()) {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("config.yml");){
                if (is != null) {
                    Files.copy(is, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    logger.info("\u5df2\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6: config.yml");
                } else {
                    HashMap<String, Object> configData = new HashMap<String, Object>();
                    configData.put("token", "Java" + this.generateRandomString());
                    configData.put("\u6d88\u606f\u524d\u7f00", "\u8054\u5408\u5c01\u7981 >>> ");
                    configData.put("\u63d0\u793a", "Token \u4ec5\u5728\u7b2c\u4e00\u6b21\u4f7f\u7528\u63d2\u4ef6\u65f6\u751f\u6210,\u8bf7\u52ff\u968f\u610f\u4fee\u6539\u6570\u503c\n\u8fd9\u662f\u670d\u52a1\u5668\u7684\u552f\u4e00\u6807\u8bc6\u7801\u3002\n\u60a8\u5e94\u8be5\u59a5\u5584\u4fdd\u7ba1\u60a8\u7684 Token ,\u8bf7\u52ff\u6cc4\u9732\u7ed9\u5176\u4ed6\u4eba\u3002\n(\u7533\u8bf7\u6743\u9650\u8bf7\u5728QQ\u7fa4 152772973 \u79c1\u804a\u7fa4\u4e3b\u83b7\u53d6,\u8be6\u60c5\u8bf7\u89c1\u7fa4\u516c\u544a\u7684\u7533\u8bf7\u89c4\u5219)\n");
                    options = new DumperOptions();
                    options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                    options.setPrettyFlow(true);
                    yaml = new Yaml(options);
                    yaml.dump(configData, (Writer)Files.newBufferedWriter(configFile.toPath(), new OpenOption[0]));
                    logger.info("\u5df2\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6: config.yml");
                }
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            }
        }
        if (!(playerDataFile = new File(this.dataDirectory.toFile(), "playerdata.yml")).exists()) {
            try {
                HashMap playerData = new HashMap();
                playerData.put("\u73a9\u5bb6\u6570\u636e", new HashMap());
                options = new DumperOptions();
                options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                options.setPrettyFlow(true);
                yaml = new Yaml(options);
                yaml.dump(playerData, (Writer)Files.newBufferedWriter(playerDataFile.toPath(), new OpenOption[0]));
                logger.info("\u5df2\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6: playerdata.yml");
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u73a9\u5bb6\u6570\u636e\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private BrigadierCommand createCloudBanCommand() {
        LiteralCommandNode cloudbanNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)"cloudban").requires(source -> source.hasPermission("uniteban.command"))).executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            source.sendMessage((Component)Component.text((String)(PT + "\u7528\u6cd5: /cloudban <\u73a9\u5bb6\u540d> <\u539f\u56e0>")));
            if (this.initConfig()) {
                source.sendMessage((Component)Component.text((String)(PT + "\u914d\u7f6e\u91cd\u8f7d\u6210\u529f")));
            } else {
                source.sendMessage((Component)Component.text((String)(PT + "\u914d\u7f6e\u91cd\u8f7d\u5931\u8d25")));
            }
            return 1;
        })).then(BrigadierCommand.requiredArgumentBuilder((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            this.server.getAllPlayers().forEach(player -> builder.suggest(player.getUsername()));
            return builder.buildFuture();
        }).then(BrigadierCommand.requiredArgumentBuilder((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            CommandSource source = (CommandSource)context.getSource();
            String playerName = (String)context.getArgument("player", String.class);
            String reason = (String)context.getArgument("reason", String.class);
            if (!playerIpMap.containsKey(playerName)) {
                source.sendMessage((Component)Component.text((String)(PT + "\u9519\u8bef: \u672a\u5728\u672c\u5730\u627e\u5230\u73a9\u5bb6 " + playerName + " \u7684IP\u8bb0\u5f55\uff0c\u65e0\u6cd5\u4e0a\u4f20\u5230\u8054\u5408\u5c01\u7981\u7cfb\u7edf")));
                return 1;
            }
            if (this.updateToCloudBlackList(playerName, reason, false)) {
                source.sendMessage((Component)Component.text((String)(PT + "\u73a9\u5bb6 " + playerName + " \u5df2\u6dfb\u52a0\u5230\u4e91\u7aef\u5c01\u7981\n\u539f\u56e0: " + reason)));
                Optional targetPlayer = this.server.getPlayer(playerName);
                if (targetPlayer.isPresent()) {
                    ((Player)targetPlayer.get()).disconnect((Component)Component.text((String)("\u00a7c\u8054\u5408\u5c01\u7981 - \u88ab\u624b\u52a8\u5c01\u7981\n\u539f\u56e0: " + reason + "\n\u7533\u8bc9\u5730\u5740\nhttps://uniteban.mcwaf.cn/appeal/")));
                    logger.info("\u73a9\u5bb6 " + playerName + " \u88ab\u624b\u52a8\u5c01\u7981\n\u539f\u56e0: " + reason);
                }
            } else {
                source.sendMessage((Component)Component.text((String)(PT + "\u4e0a\u4f20\u5c01\u7981\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u627e\u5230\u8be5\u73a9\u5bb6\u7684IP\u8bb0\u5f55")));
            }
            return 1;
        })))).build();
        return new BrigadierCommand(cloudbanNode);
    }

    private void sendServerRegistration() {
        if (!this.registrationSent.compareAndSet(false, true)) {
            return;
        }
        try {
            String jsonData = String.format("{\"mac\":\"%s\",\"token\":\"%s\"}", Uniteban.getMacAddress(), token);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://uniteban.mcwaf.cn/innerapi.php")).header("Content-Type", "application/json").timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
            HttpResponse<String> response = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            switch (response.statusCode()) {
                case 200: {
                    logger.info("\u670d\u52a1\u5668\u6ce8\u518c\u4fe1\u606f\u5df2\u53d1\u9001\u81f3 UniteBan \u4e91\u7aef\u3002");
                    break;
                }
                case 403: {
                    logger.warn("\u670d\u52a1\u5668\u6ce8\u518c\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u4e0a\u4f20\u6743\u9650\u3002\u5982\u679c\u60a8\u4e5f\u60f3\u4e3a\u8054\u5408\u5c01\u7981\u505a\u51fa\u8d21\u732e\uff0c\u6b22\u8fce\u524d\u5f80\u7f51\u7ad9 https://uniteban.mcwaf.cn/ \u7533\u8bf7\u6743\u9650\u3002");
                    break;
                }
                default: {
                    logger.error("\u670d\u52a1\u5668\u6ce8\u518c\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.statusCode());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u670d\u52a1\u5668\u6ce8\u518c\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
    }

    @Subscribe
    public void onPostLogin(PostLoginEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("uniteban.bypass")) {
            return;
        }
        String ip = player.getRemoteAddress().getAddress().getHostAddress();
        String playerName = player.getUsername();
        playerIpMap.put(playerName, ip);
        this.setConfig("playerdata", "\u73a9\u5bb6\u6570\u636e", playerIpMap);
        if (!this.isPrivateIP(ip)) {
            this.checkCloudBan(player);
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.updateServerPlayers();
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u670d\u52a1\u5668\u73a9\u5bb6\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            }
        });
    }

    private void updateServerPlayers() {
        try {
            int onlineCount = this.server.getPlayerCount();
            int maxPlayers = this.server.getConfiguration().getShowMaxPlayers();
            String jsonData = String.format("{\"mac\":\"%s\",\"online\":%d,\"max\":%d}", Uniteban.getMacAddress(), onlineCount, maxPlayers);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://uniteban.mcwaf.cn/servers.php?action=update")).header("Content-Type", "application/json").timeout(Duration.ofSeconds(10L)).POST(HttpRequest.BodyPublishers.ofString(jsonData)).build();
            HttpResponse<String> httpResponse = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            logger.error("\u6784\u5efa\u6216\u53d1\u9001\u670d\u52a1\u5668\u73a9\u5bb6\u4fe1\u606f\u66f4\u65b0\u8bf7\u6c42\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    private boolean isPrivateIP(String ip) {
        if (ip == null || ip.isEmpty()) {
            return true;
        }
        return PRIVATE_IP_PATTERN.matcher(ip).matches() || ip.equals("::1") || ip.startsWith("fc00:") || ip.startsWith("fd00:") || ip.startsWith("fe80:");
    }

    private String generateRandomString() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 28; ++i) {
            sb.append(chars.charAt(new Random().nextInt(chars.length())));
        }
        return sb.toString();
    }

    public boolean initConfig() {
        HashMap playerData = this.getConfig("playerdata", "\u73a9\u5bb6\u6570\u636e", new HashMap());
        if (playerData instanceof Map) {
            try {
                Map castedData = playerData;
                playerIpMap = new ConcurrentHashMap(castedData);
                logger.info("\u4ece playerdata.yml \u52a0\u8f7d\u4e86 " + playerIpMap.size() + " \u6761\u73a9\u5bb6\u6570\u636e\u3002");
            }
            catch (ClassCastException e) {
                logger.error("playerdata.yml \u4e2d\u7684\u6570\u636e\u65e0\u6cd5\u8f6c\u6362\u4e3a Map<String, String> \u683c\u5f0f: " + e.getMessage());
                playerIpMap = new ConcurrentHashMap();
                return false;
            }
        } else {
            logger.warn("playerdata.yml \u52a0\u8f7d\u5931\u8d25\u6216\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u521d\u59cb\u5316\u4e3a\u7a7a\u6620\u5c04\u3002");
            playerIpMap = new ConcurrentHashMap();
        }
        token = (String)((Object)this.getConfig("config", "token", "Java" + this.generateRandomString()));
        PT = this.getConfig("config", "\u6d88\u606f\u524d\u7f00", "\u8054\u5408\u5c01\u7981 >>> ");
        return true;
    }

    public static String getMacAddress() {
        try {
            byte[] mac;
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network != null && (mac = network.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                }
                return sb.toString();
            }
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6 MAC \u5730\u5740");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6MAC\u5730\u5740\u5931\u8d25: " + e.getMessage());
            return "00:00:00:00:00:00";
        }
    }

    public boolean updateToCloudBlackList(String player, String reason, boolean sendSuccessMeg) {
        String playerIp = playerIpMap.get(player);
        if (playerIp == null || playerIp.isEmpty()) {
            logger.warn("\u5c1d\u8bd5\u4e0a\u4f20\u73a9\u5bb6 " + player + " \u5230\u4e91\u9ed1\u65f6\uff0c\u672a\u5728\u672c\u5730\u7f13\u5b58\u4e2d\u627e\u5230\u5176 IP \u5730\u5740\u3002\u53d6\u6d88\u4e0a\u4f20\u3002");
            return false;
        }
        String finalPlayerIp = playerIp;
        CompletableFuture.runAsync(() -> {
            try {
                HttpResponse<String> response = Uniteban.getHttpURLResponse(String.format("{\"name\":\"%s\",\"ip\":\"%s\",\"mac\":\"%s\",\"token\":\"%s\",\"reason\":\"%s\"}", player, finalPlayerIp, Uniteban.getMacAddress(), token, reason), "https://uniteban.mcwaf.cn/innerapi.php");
                switch (response.statusCode()) {
                    case 200: {
                        if (sendSuccessMeg) {
                            logger.info("\u73a9\u5bb6 " + player + " \u5df2\u6210\u529f\u52a0\u5165\u4e91\u9ed1\u5217\u8868\n\u539f\u56e0: " + reason);
                        }
                        break;
                    }
                    case 403: {
                        logger.warn("\u4e0a\u4f20\u5931\u8d25, \u672a\u83b7\u53d6\u4e0a\u4f20\u6743\u9650\u3002\u5982\u679c\u60a8\u4e5f\u60f3\u4e3a\u8054\u5408\u5c01\u7981\u505a\u51fa\u8d21\u732e, \u6b22\u8fce\u524d\u5f80\u7f51\u7ad9 https://uniteban.mcwaf.cn/ \u7533\u8bf7\u6743\u9650");
                        break;
                    }
                    default: {
                        logger.error("\u4e0a\u4f20\u5931\u8d25: \u72b6\u6001\u7801 " + response.statusCode() + ", \u54cd\u5e94\u4f53: " + response.body());
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u8bf7\u6c42\u5f02\u5e38 (\u6dfb\u52a0\u4e91\u9ed1): " + String.valueOf(e));
            }
        });
        return true;
    }

    private void checkCloudBan(Player player) {
        CompletableFuture.runAsync(() -> {
            try {
                String playerIp = playerIpMap.get(player.getUsername());
                HttpResponse<String> response = Uniteban.getHttpURLResponse(String.format("{\"name\":\"%s\",\"ip\":\"%s\"}", player.getUsername(), playerIp != null ? playerIp : ""), "https://uniteban.mcwaf.cn/api.php");
                int status = response.statusCode();
                if (status == 200) {
                    if (response.body().contains("\"exists\":true")) {
                        int reasonEnd;
                        String reason = "\u8fdd\u89c4\u884c\u4e3a";
                        String responseBody = response.body();
                        int reasonStart = responseBody.indexOf("\"reason\":\"");
                        if (reasonStart != -1 && (reasonEnd = responseBody.indexOf("\"", reasonStart += 10)) != -1) {
                            reason = responseBody.substring(reasonStart, reasonEnd);
                        }
                        logger.info("\u73a9\u5bb6 " + player.getUsername() + " \u8054\u5408\u5c01\u7981 - \u68c0\u67e5\u672a\u901a\u8fc7, \u539f\u56e0: " + reason);
                        player.disconnect((Component)Component.text((String)("\u00a7c\u8054\u5408\u5c01\u7981 - \u68c0\u67e5\u672a\u901a\u8fc7\n\u539f\u56e0: " + reason + "\n\u7533\u8bc9\u5730\u5740\nhttps://uniteban.mcwaf.cn/appeal/")));
                    }
                } else {
                    logger.error("\u68c0\u67e5\u5931\u8d25,\u72b6\u6001\u7801: " + status + ", \u54cd\u5e94\u4f53: " + response.body());
                }
            }
            catch (Exception e) {
                logger.error("\u5c01\u7981\u68c0\u67e5\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage());
            }
        });
    }

    private static HttpResponse<String> getHttpURLResponse(String postData, String Url) throws Exception {
        String correctedUrl = Url.trim();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(correctedUrl)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofString(postData)).build();
        return CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
    }

    private <T> T getConfig(String path, String name, T defaultValue) {
        try {
            File file = new File(this.dataDirectory.toFile(), path + ".yml");
            if (!file.exists()) {
                this.createDefaultConfigs();
                return defaultValue;
            }
            Yaml yaml = new Yaml();
            Map data = (Map)yaml.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
            if (data == null || !data.containsKey(name)) {
                data = data != null ? data : new HashMap();
                data.put(name, defaultValue);
                DumperOptions options = new DumperOptions();
                options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                options.setPrettyFlow(true);
                Yaml outputYaml = new Yaml(options);
                outputYaml.dump((Object)data, (Writer)Files.newBufferedWriter(file.toPath(), new OpenOption[0]));
                return defaultValue;
            }
            return (T)data.get(name);
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
            return defaultValue;
        }
    }

    private void setConfig(String path, String name, Object value) {
        try {
            Yaml yaml;
            File file = new File(this.dataDirectory.toFile(), path + ".yml");
            Map<String, Object> data = new HashMap<String, Object>();
            if (file.exists() && (data = (Map)(yaml = new Yaml()).load(Files.newInputStream(file.toPath(), new OpenOption[0]))) == null) {
                data = new HashMap();
            }
            data.put(name, value);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            Yaml yaml2 = new Yaml(options);
            yaml2.dump(data, (Writer)Files.newBufferedWriter(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    static {
        IPV4_PATTERN = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
        PRIVATE_IP_PATTERN = Pattern.compile("^(127\\.0\\.0\\.1)|(10\\..*)|(172\\.1[6-9]\\..*)|(172\\.2[0-9]\\..*)|(172\\.3[0-1]\\..*)|(192\\.168\\..*)");
        playerIpMap = new ConcurrentHashMap();
        CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        logger = null;
    }
}

