/*
 * Decompiled with CFR 0.152.
 */
package Org.UniteBan_Nukkit;

import Org.UniteBan_Nukkit.Configs;
import Org.UniteBan_Nukkit.Main;
import Org.UniteBan_Nukkit.UI.AbstractFakeInventory;
import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.network.protocol.AddItemEntityPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.scheduler.Task;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class Utils {
    public static final String ckUrl = "https://uniteban.mcwaf.cn/api.php";
    public static final String upUrl = "https://uniteban.mcwaf.cn/innerapi.php";
    public static final String ndTip = "\u4e0a\u4f20\u5931\u8d25, \u672a\u83b7\u53d6\u4e0a\u4f20\u6743\u9650\n\u00a7r\n\u00a7e\u5982\u679c\u60a8\u4e5f\u60f3\u4e3a\u8054\u5408\u5c01\u7981\u505a\u51fa\u8d21\u732e, \u6b22\u8fce\u524d\u5f80\u7f51\u7ad9\u00a76 https://uniteban.mcwaf.cn \u00a7e\u7533\u8bf7\u6743\u9650\n\u00a7r\n";
    private static int rc = -1;
    private static final HttpClient CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    public static String CORE_NAME = "";
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");

    public static String getPlayerName(Player p) {
        return p.getName();
    }

    public static List<String> getLowManetLevelPlayerNames(Player p) {
        ArrayList<String> list = new ArrayList<String>();
        int lv = Configs.getPlayerMangentLevel(p);
        if (!p.isOp()) {
            Main.nks.getOnlinePlayers().values().forEach(target -> {
                if (!target.isOp() && lv > Configs.getPlayerMangentLevel(target)) {
                    list.add(Utils.getPlayerName(target));
                }
            });
        } else {
            Main.nks.getOnlinePlayers().values().forEach(target -> {
                if (!target.isOp()) {
                    list.add(Utils.getPlayerName(target));
                }
            });
        }
        return list;
    }

    public static List<String> getAllReportPlayers(Player p) {
        ArrayList<String> list = new ArrayList<String>();
        Main.nks.getOnlinePlayers().values().forEach(target -> {
            if (!target.isOp() && !target.getName().equals(p.getName())) {
                list.add(Utils.getPlayerName(target));
            }
        });
        return list;
    }

    public static Player getPlayerTarget(String playerName) {
        return Main.nks.getPlayer(playerName);
    }

    public static String convertSecondsToTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder result = new StringBuilder();
        if (days > 0L) {
            result.append(days).append("\u5929");
        }
        if (hours > 0L) {
            result.append(hours).append("\u65f6");
        }
        if (minutes > 0L) {
            result.append(minutes).append("\u5206");
        }
        if (seconds > 0L || result.isEmpty()) {
            result.append(seconds).append("\u79d2");
        }
        return result.toString().trim();
    }

    public static void Delayed(final Runnable logic, int time, boolean async) {
        Main.nks.getScheduler().scheduleDelayedTask(new Task(){

            public void onRun(int i) {
                logic.run();
            }
        }, time, async);
    }

    public static String genRandom32Token() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String genRandomTickets() {
        return new SimpleDateFormat("yyMMdd") + UUID.randomUUID().toString().replace("-", "");
    }

    public static String get16ByteKeyInToken() {
        return Configs.getToken().substring(8, 24);
    }

    public static String encrypt(String content) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(Utils.get16ByteKeyInToken().getBytes(), "AES");
            cipher.init(1, (Key)secretKey, new IvParameterSpec("ModeOf TiXYA2357".getBytes(StandardCharsets.UTF_8)));
            byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String decrypt(String content) {
        if (content.isEmpty()) {
            return "null";
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(Utils.get16ByteKeyInToken().getBytes(), "AES");
            cipher.init(2, (Key)secretKey, new IvParameterSpec("ModeOf TiXYA2357".getBytes(StandardCharsets.UTF_8)));
            byte[] decrypted = cipher.doFinal(Base64.getDecoder().decode(content));
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMacAddress() {
        if (Configs.getMacCode() != null && !Configs.getMacCode().isEmpty()) {
            return Configs.getMacCode();
        }
        String out = "";
        try {
            out = Utils.subGetMacAddress();
        }
        catch (Exception e) {
            Main.nks.getLogger().warning("\u65e0\u6cd5\u83b7\u53d6 MAC \u5730\u5740, \u5c06\u9ed8\u8ba4\u751f\u6210!");
            out = Utils.simpleStringToMac();
        }
        Configs.setConfig("Config", "MAC\u5730\u5740", out);
        return out;
    }

    private static String subGetMacAddress() throws Exception {
        InetAddress ip = InetAddress.getLocalHost();
        NetworkInterface network = NetworkInterface.getByInetAddress(ip);
        if (network != null) {
            byte[] mac = network.getHardwareAddress();
            if (mac != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                }
                return sb.toString();
            }
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6 MAC \u5730\u5740\uff0c\u786c\u4ef6\u5730\u5740\u4e3a null");
        }
        throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u7f51\u7edc\u63a5\u53e3\u4fe1\u606f");
    }

    private static String simpleStringToMac() {
        int hash = Configs.getToken().hashCode();
        StringBuilder mac = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            int value = hash >> i * 8 & 0xFF;
            String hex = String.format("%02X", value);
            mac.append(hex);
            if (i >= 5) continue;
            mac.append(":");
        }
        return mac.toString();
    }

    public static void updateToCloudBlackList(Player player, String reason, boolean sendSuccessMeg) {
        Utils.updateToCloudBlackList(player.getName(), reason, sendSuccessMeg, null);
    }

    public static void updateToCloudBlackList(String playerName, @NotNull String reason, boolean sendSuccessMeg, CommandSender sender) {
        if (reason == null) {
            Utils.$$$reportNull$$$0(0);
        }
        Utils.Delayed(() -> {
            if (!Configs.playerDates.containsKey(playerName)) {
                Main.nks.getLogger().warning("\u73a9\u5bb6 " + playerName + " \u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6570\u636e\u53ef\u4e0a\u4f20");
                return;
            }
            try {
                HashMap<String, Object> info = Configs.playerDates.get(playerName);
                HttpResponse<String> response = Utils.getHttpURLResponse(Map.of("reason", reason, "name", playerName, "token", Configs.getToken(), "mac", Utils.getMacAddress(), "xuid", Objects.requireNonNull(Utils.decrypt(info.getOrDefault("XUID", "").toString())), "uuid", Objects.requireNonNull(Utils.decrypt(info.getOrDefault("UUID", "").toString())), "ip", Objects.requireNonNull(Utils.decrypt(info.getOrDefault("IP", "").toString())), "clientId", Objects.requireNonNull(Utils.decrypt(info.getOrDefault("ClientID", "").toString()))), upUrl);
                switch (response.statusCode()) {
                    case 200: {
                        if (sender != null) {
                            sender.sendMessage(Configs.PT + "\u73a9\u5bb6 " + playerName + " \u5df2\u6210\u529f\u52a0\u5165\u4e91\u9ed1\u5217\u8868");
                        } else if (sendSuccessMeg) {
                            Main.nks.getLogger().info(Configs.PT + "\u73a9\u5bb6 " + playerName + " \u5df2\u6210\u529f\u52a0\u5165\u4e91\u9ed1\u5217\u8868");
                        }
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            String log = "[" + new SimpleDateFormat("HH:mm:ss") + "] " + Utils.getPlayerName(player) + " \u5c06\u73a9\u5bb6 " + playerName + " \u4e0a\u4f20\u81f3\u4e91\u9ed1";
                            Configs.addMangentOperatorsLog(log);
                        }
                        break;
                    }
                    case 403: {
                        Main.nks.getLogger().warning(ndTip);
                        if (sender != null) {
                            sender.sendMessage(ndTip);
                        }
                        break;
                    }
                    default: {
                        Main.nks.getLogger().error("\u4e0a\u4f20\u5931\u8d25, \u72b6\u6001\u7801: " + response.statusCode());
                    }
                }
            }
            catch (Exception e) {
                Main.nks.getLogger().error("\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage());
            }
        }, 1, true);
    }

    public static void checkCloudBan(@NotNull String playerName, @NotNull String XUID, @NotNull String UUID2, @NotNull String ClientID, @NotNull String IP) {
        if (playerName == null) {
            Utils.$$$reportNull$$$0(1);
        }
        if (XUID == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if (UUID2 == null) {
            Utils.$$$reportNull$$$0(3);
        }
        if (ClientID == null) {
            Utils.$$$reportNull$$$0(4);
        }
        if (IP == null) {
            Utils.$$$reportNull$$$0(5);
        }
        Utils.Delayed(() -> {
            try {
                HttpResponse<String> response = Utils.getHttpURLResponse(Map.of("xuid", XUID, "uuid", UUID2, "ip", IP, "clientId", ClientID), ckUrl);
                int status = response.statusCode();
                if (status == 200) {
                    JsonNode jsonNode = new ObjectMapper().readTree(response.body());
                    if (jsonNode.has("exists") && jsonNode.get("exists").asBoolean()) {
                        String reason;
                        Player target = Utils.getPlayerTarget(playerName);
                        String string = reason = jsonNode.has("reason") ? jsonNode.get("reason").asText() : "null";
                        if (Configs.isKickOnUpDate()) {
                            Utils.updateToCloudBlackList(target, reason, true);
                        }
                        Main.nks.getLogger().warning("\u73a9\u5bb6 " + Utils.getPlayerName(target) + " \u8054\u5408\u5c01\u7981 - \u68c0\u67e5\u672a\u901a\u8fc7");
                        if (target != null) {
                            target.kick("\u00a7c\u8054\u5408\u5c01\u7981 - \u68c0\u67e5\u672a\u901a\u8fc7\n" + (String)(!reason.equals("null") ? "\u5c01\u7981\u539f\u56e0: " + reason : "") + "\n\u00a7f\u7533\u8bc9\u5730\u5740\nhttps://uniteban.mcwaf.cn/appeal", false);
                        }
                        Utils.Delayed(() -> {
                            if (target != null) {
                                Main.nks.broadcastMessage(Configs.PT + "\u73a9\u5bb6 " + Utils.getPlayerName(target) + " \u5177\u6709\u9632\u8e22\u529f\u80fd,\u5df2\u5d29\u6e83\u5176\u5ba2\u6237\u7aef");
                                AddItemEntityPacket pk = new AddItemEntityPacket();
                                Random random = new Random();
                                random.setSeed(System.currentTimeMillis() + random.nextLong());
                                pk.entityRuntimeId = pk.entityUniqueId = random.nextLong();
                                pk.item = new Item(441, Integer.valueOf(255));
                                pk.speedX = 0.0f;
                                pk.speedY = 0.0f;
                                pk.speedZ = 0.0f;
                                long flags = 65536L;
                                pk.metadata = new EntityMetadata().putLong(0, flags).putLong(37, -1L).putFloat(38, 4.0f);
                                target.dataPacket((DataPacket)pk);
                            }
                        }, 1, false);
                    }
                } else {
                    Main.nks.getLogger().error("\u8bbf\u95ee\u4e91\u9ed1\u68c0\u6d4b\u5931\u8d25");
                    if (Configs.debugMode) {
                        Main.nks.getLogger().error("\u72b6\u6001\u7801: " + status);
                    }
                }
            }
            catch (IOException e) {
                switch (rc) {
                    case -1: {
                        rc = Configs.getNumberOfReconnections();
                        break;
                    }
                    case 0: {
                        Main.nks.getLogger().error("\u8bbf\u95ee\u4e91\u9ed1\u68c0\u6d4b\u5931\u8d25, \u5df2\u53d6\u6d88\u91cd\u8fde, \u8bf7\u68c0\u67e5\u7f51\u7edc\u73af\u5883!");
                        rc = -1;
                        break;
                    }
                    default: {
                        Main.nks.getLogger().error("\u8bbf\u95ee\u4e91\u9ed1\u68c0\u6d4b\u5931\u8d25, \u91cd\u8bd5\u4e2d... \u5269\u4f59\u91cd\u8bd5\u6b21\u6570: " + --rc);
                        Utils.checkCloudBan(playerName, XUID, UUID2, ClientID, IP);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Main.nks.getLogger().error("\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage());
            }
        }, 1, true);
    }

    public static HttpResponse<String> getHttpURLResponse(Map<?, ?> postData, String Url) throws Exception {
        String requestBody;
        try {
            requestBody = new ObjectMapper().writeValueAsString(postData);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u8f6c\u6362\u81f3Json\u5b57\u7b26\u4e32\u65f6\u9047\u5230\u9519\u8bef: ", e);
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(Url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        return CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public static void JsonToYAML(String jsonString, String File2) {
        Map data = (Map)new Yaml().load(jsonString);
        try (FileWriter fileWriter = new FileWriter(File2);){
            new Yaml().dump((Object)data, (Writer)fileWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void asOPCmd(Player p, String cmd) {
        boolean flag = p.isOp();
        if (!flag) {
            p.setOp(true);
        }
        Arrays.stream(cmd.split("&")).forEach(c -> {
            if (!c.isEmpty()) {
                Main.nks.dispatchCommand((CommandSender)p, c.replace("@p", p.getName()).replaceFirst("/", ""));
            }
        });
        if (!flag) {
            p.setOp(false);
        }
    }

    public static void checkServer() {
        Main.Delayed(() -> {
            boolean ver = false;
            CORE_NAME = "Nukkit";
            try {
                Class.forName("cn.nukkit.Nukkit").getField("NUKKIT_PM1E");
                ver = true;
                CORE_NAME = "Nukkit PM1E";
            }
            catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            try {
                Field c = Class.forName("cn.nukkit.Nukkit").getField("NUKKIT");
                CORE_NAME = c.get(c).toString();
                ver = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            AbstractFakeInventory.IS_PM1E = ver;
            if (ver) {
                Main.nks.enableExperimentMode = true;
                Main.nks.forceResources = true;
            }
        }, 1, true);
    }

    public static Item ChestMenuTo(@NotNull Item item, int count, int Meta, String Name) {
        if (item == null) {
            Utils.$$$reportNull$$$0(6);
        }
        return Utils.ChestMenuTo(item, count, Meta, Name, "");
    }

    public static Item ChestMenuTo(@NotNull Item item, int count, int Meta, String Name, String Lore) {
        if (item == null) {
            Utils.$$$reportNull$$$0(7);
        }
        item.setCount(count);
        item.setDamage(Integer.valueOf(Meta));
        item.setCustomName("\u00a7r" + Name.replace("&", "\u00a7"));
        item.addEnchantment(new Enchantment[]{Enchantment.get((int)22).setLevel(Short.MAX_VALUE, false)});
        if (!Lore.isEmpty()) {
            item.setLore(new String[]{Lore.replace("@n", "\n")});
        }
        return item;
    }

    public static boolean isAdmin(Player p) {
        return p.isOp() || Configs.getPlayerMangentLevel(p) > 0;
    }

    public static String getNowTime() {
        return DATE_TIME_FORMAT.format(new Date());
    }

    public static String setDateTime(TimeType type, String dateTimeStr, int Seconds) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TimeType.ADD -> Utils.secondsToDateTime(Utils.secondsLeft(dateTimeStr) + (long)Seconds);
            case TimeType.SET -> Utils.secondsToDateTime(Seconds);
            case TimeType.DEL -> Utils.secondsToDateTime(Utils.secondsLeft(dateTimeStr) - (long)Seconds);
        };
    }

    public static long secondsLeft(String dateTimeStr) {
        try {
            Date targetDate = DATE_TIME_FORMAT.parse(dateTimeStr);
            long timeDiffMillis = targetDate.getTime() - new Date().getTime();
            return timeDiffMillis / 1000L;
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    public static String secondsToDateTime(long seconds) {
        Date date = new Date(System.currentTimeMillis() + seconds * 1000L);
        return DATE_TIME_FORMAT.format(date);
    }

    public static String compareDateTime(String dateTimeStr1, String dateTimeStr2) {
        try {
            long s1 = Utils.secondsLeft(dateTimeStr1);
            long s2 = Utils.secondsLeft(dateTimeStr2);
            return s1 == s2 ? "\u7b49\u4e8e" : (s1 > s2 ? "\u665a\u4e8e" : "\u65e9\u4e8e");
        }
        catch (Exception e) {
            System.out.println("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e: " + e.getMessage());
            return null;
        }
    }

    static {
        DATE_TIME_FORMAT.setTimeZone(TimeZone.getDefault());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "playerName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "XUID";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "UUID";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ClientID";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "IP";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "Org/UniteBan_Nukkit/Utils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateToCloudBlackList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCloudBan";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "ChestMenuTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum TimeType {
        ADD,
        SET,
        DEL;

    }
}

