/*
 * Decompiled with CFR 0.152.
 */
package Org.UniteBan_Nukkit.UI;

import Org.UniteBan_Nukkit.UI.FakeInventoryChest;
import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class MenuChest
extends FakeInventoryChest {
    private final List<Button> buttons = new ArrayList<Button>();
    long id;
    private Runnable close;

    public MenuChest(String title) {
        super(InventoryType.CHEST, null, title);
        this.close = () -> {};
        this.setName(title);
    }

    public MenuChest(String title, boolean autoClose) {
        super(InventoryType.CHEST, null, title);
        this.close = () -> {};
        this.setName(title);
        super.setAutoClose(autoClose);
    }

    public MenuChest(String title, boolean autoClose, boolean async) {
        super(InventoryType.CHEST, null, title);
        this.close = () -> {};
        this.setName(title);
        super.setAutoClose(autoClose);
        super.setAsync(async);
    }

    public void add(int slot, Item item, Runnable runnable) {
        slot = Math.min(Math.max(1, slot), this.getSize() + 1);
        this.buttons.add(new Button(slot - 1, item, runnable));
    }

    public void show(Player player) {
        this.id = Entity.entityCount++;
        LinkedHashMap<Integer, Item> itemMap = new LinkedHashMap<Integer, Item>();
        HashMap<Integer, Runnable> rs = new HashMap<Integer, Runnable>();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (Button button : this.buttons) {
            itemMap.put(button.slot, button.item);
            rs.put(button.slot, button.callback);
            slots.add(button.slot);
        }
        this.setContents(itemMap);
        this.setRs(rs);
        this.setSlots(slots);
        this.setPlayer(player);
        player.addWindow((Inventory)this);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public void onSlotChange(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        ContainerOpenPacket pk = new ContainerOpenPacket();
        pk.windowId = who.getWindowId((Inventory)this);
        pk.entityId = this.id;
        pk.type = InventoryType.CHEST.getNetworkType();
        who.dataPacket((DataPacket)pk);
    }

    @Override
    public void onClose(Player who) {
        RemoveEntityPacket pk = new RemoveEntityPacket();
        pk.eid = this.id;
        who.dataPacket((DataPacket)pk);
        super.onClose(who);
        if (this.close != null) {
            this.close.run();
        }
    }

    public Runnable getClose() {
        return this.close;
    }

    public void setClose(Runnable close) {
        this.close = close;
    }

    static class Button {
        public int slot;
        public Item item;
        public Runnable callback;

        public Button(int slot, Item item, Runnable runnable) {
            this.item = item;
            this.callback = runnable;
            this.slot = slot;
        }
    }
}

