/*
 * Decompiled with CFR 0.152.
 */
package Org.UniteBan_Nukkit.UI;

import Org.UniteBan_Nukkit.Main;
import cn.nukkit.Player;
import cn.nukkit.form.element.Element;
import cn.nukkit.form.element.ElementLabel;
import cn.nukkit.form.handler.FormResponseHandler;
import cn.nukkit.form.window.FormWindow;
import cn.nukkit.form.window.FormWindowCustom;
import java.util.ArrayList;
import java.util.List;

public class Form_Custom {
    private final List<String> elements = new ArrayList<String>();
    private FormWindowCustom form;
    private Runnable close;
    private Runnable submit;

    public Form_Custom(String title) {
        this.form = new FormWindowCustom(title);
    }

    public String add(String Label) {
        String key = this.getRandKey();
        this.elements.add(key);
        this.form.addElement((Element)new ElementLabel(Label));
        return key;
    }

    private String getRandKey() {
        return "custom_" + Math.random();
    }

    public void add(String key, Element element) {
        this.elements.add(key);
        this.form.addElement(element);
    }

    public void show(Player player) {
        this.form.addHandler(FormResponseHandler.withoutPlayer(ignored -> this.processReturns()));
        player.showFormWindow((FormWindow)this.form);
    }

    private void processReturns() {
        if (this.form.wasClosed()) {
            if (this.close != null) {
                this.close.run();
            }
            return;
        }
        if (this.submit != null) {
            this.submit.run();
        }
    }

    public void asyncShow(Player player) {
        this.form.addHandler(FormResponseHandler.withoutPlayer(ignored -> Main.Delayed(this::processReturns, 0, true)));
        player.showFormWindow((FormWindow)this.form);
    }

    public <T> T getRes(String key) {
        return (T)this.form.getResponse().getResponse(this.elements.indexOf(key));
    }

    public String getInputRes(String key) {
        return this.form.getResponse().getInputResponse(this.elements.indexOf(key));
    }

    public String getDropdownRes(String key) {
        return this.form.getResponse().getDropdownResponse(this.elements.indexOf(key)).getElementContent();
    }

    public String getStepSliderRes(String key) {
        return this.form.getResponse().getStepSliderResponse(this.elements.indexOf(key)).getElementContent();
    }

    public int getStepSliderIdRes(String key) {
        return this.form.getResponse().getStepSliderResponse(this.elements.indexOf(key)).getElementID();
    }

    public int getDropdownIndexRes(String key) {
        return this.form.getResponse().getDropdownResponse(this.elements.indexOf(key)).getElementID();
    }

    public float getSliderRes(String key) {
        return this.form.getResponse().getSliderResponse(this.elements.indexOf(key));
    }

    public boolean getToggleRes(String key) {
        return this.form.getResponse().getToggleResponse(this.elements.indexOf(key));
    }

    public List<String> getElements() {
        return this.elements;
    }

    public FormWindowCustom getForm() {
        return this.form;
    }

    public Runnable getClose() {
        return this.close;
    }

    public Runnable getSubmit() {
        return this.submit;
    }

    public void setForm(FormWindowCustom form) {
        this.form = form;
    }

    public void setClose(Runnable close) {
        this.close = close;
    }

    public void setSubmit(Runnable submit) {
        this.submit = submit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Form_Custom)) {
            return false;
        }
        Form_Custom other = (Form_Custom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$elements = this.getElements();
        List<String> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        FormWindowCustom this$form = this.getForm();
        FormWindowCustom other$form = other.getForm();
        if (this$form == null ? other$form != null : !this$form.equals(other$form)) {
            return false;
        }
        Runnable this$close = this.getClose();
        Runnable other$close = other.getClose();
        if (this$close == null ? other$close != null : !this$close.equals(other$close)) {
            return false;
        }
        Runnable this$submit = this.getSubmit();
        Runnable other$submit = other.getSubmit();
        return !(this$submit == null ? other$submit != null : !this$submit.equals(other$submit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Form_Custom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        FormWindowCustom $form = this.getForm();
        result = result * 59 + ($form == null ? 43 : $form.hashCode());
        Runnable $close = this.getClose();
        result = result * 59 + ($close == null ? 43 : $close.hashCode());
        Runnable $submit = this.getSubmit();
        result = result * 59 + ($submit == null ? 43 : $submit.hashCode());
        return result;
    }

    public String toString() {
        return "Form_Custom(elements=" + this.getElements() + ", form=" + this.getForm() + ", close=" + this.getClose() + ", submit=" + this.getSubmit() + ")";
    }
}

