/*
 * Decompiled with CFR 0.152.
 */
package Org.UniteBan_Nukkit.UI;

import cn.nukkit.Player;
import cn.nukkit.event.inventory.InventoryTransactionEvent;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractFakeInventory
extends ContainerInventory {
    public static HashMap<String, Runnable> BagOpened = new HashMap();
    private static final BlockVector3 ZERO = new BlockVector3(0, 0, 0);
    private static final Map<String, AbstractFakeInventory> OPEN = new ConcurrentHashMap<String, AbstractFakeInventory>();
    public static boolean IS_PM1E = false;
    public static final Map<String, List<BlockVector3>> blockPositions = new HashMap<String, List<BlockVector3>>();
    private final String title;
    private final ExecutorService service = Executors.newSingleThreadExecutor();
    private HashMap<Integer, Runnable> rs = new HashMap();
    private List<Integer> slots = new ArrayList<Integer>();
    private InventoryTransactionEvent event;
    private boolean autoClose = false;
    private Player player;
    private boolean async = false;
    private boolean isBag = false;

    AbstractFakeInventory(InventoryType type, InventoryHolder holder, String title) {
        super(holder, type);
        this.title = title == null ? type.getDefaultTitle() : title;
    }

    public void onOpen(Player who) {
        this.viewers.add(who);
        if (OPEN.putIfAbsent(who.getName(), this) != null) {
            throw new IllegalStateException("\u7bb1\u5b50\u5df2\u88ab\u6253\u5f00");
        }
        List<BlockVector3> blocks = this.onOpenBlock(who);
        blockPositions.put(who.getName(), blocks);
        this.onFakeOpen(who, blocks);
    }

    void onFakeOpen(Player who, List<BlockVector3> blocks) {
        BlockVector3 blockPosition = blocks.isEmpty() ? ZERO : blocks.get(0);
        ContainerOpenPacket containerOpen = new ContainerOpenPacket();
        containerOpen.windowId = who.getWindowId((Inventory)this);
        containerOpen.type = this.getType().getNetworkType();
        containerOpen.x = blockPosition.x;
        containerOpen.y = blockPosition.y;
        containerOpen.z = blockPosition.z;
        who.dataPacket((DataPacket)containerOpen);
        this.sendContents(who);
    }

    protected abstract List<BlockVector3> onOpenBlock(Player var1);

    public void onClose(Player who) {
        super.onClose(who);
        OPEN.remove(who.getName(), (Object)this);
        List<BlockVector3> blocks = blockPositions.get(who.getName());
        if (blocks == null) {
            return;
        }
        int i = 0;
        int size = blocks.size();
        while (i < size) {
            int index = i++;
            this.service.execute(() -> {
                Vector3 blockPosition = ((BlockVector3)blocks.get(index)).asVector3();
                UpdateBlockPacket updateBlock = new UpdateBlockPacket();
                updateBlock.blockRuntimeId = IS_PM1E ? GlobalBlockPalette.getOrCreateRuntimeId((int)who.protocol, (int)who.getLevel().getBlock(blockPosition).getFullId()) : GlobalBlockPalette.getOrCreateRuntimeId((int)who.getLevel().getBlock(blockPosition).getFullId());
                updateBlock.flags = 11;
                updateBlock.x = blockPosition.getFloorX();
                updateBlock.y = blockPosition.getFloorY();
                updateBlock.z = blockPosition.getFloorZ();
                who.dataPacket((DataPacket)updateBlock);
            });
        }
    }

    public String getTitle() {
        return this.title;
    }

    public HashMap<Integer, Runnable> getRs() {
        return this.rs;
    }

    public void setRs(HashMap<Integer, Runnable> rs) {
        this.rs = rs;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Integer> slots) {
        this.slots = slots;
    }

    public InventoryTransactionEvent getEvent() {
        return this.event;
    }

    public void setEvent(InventoryTransactionEvent event) {
        this.event = event;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isBag() {
        return this.isBag;
    }

    public void setBag(boolean isBag) {
        this.isBag = isBag;
    }
}

