/*
 * Decompiled with CFR 0.152.
 */
package Org.UniteBan_Nukkit;

import Org.UniteBan_Nukkit.CloudBlacksCommand;
import Org.UniteBan_Nukkit.Configs;
import Org.UniteBan_Nukkit.EventsListener;
import Org.UniteBan_Nukkit.Utils;
import cn.nukkit.Server;
import cn.nukkit.command.Command;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.scheduler.Task;
import java.net.http.HttpResponse;
import java.util.Map;

public class Main
extends PluginBase {
    private static String ConfigPath;
    public static final Server nks;
    private static Main main;

    public void onEnable() {
        this.getLogger().info("\u63d2\u4ef6\u52a0\u8f7d\u6210\u529f");
        this.getLogger().info("\u00a7e\u4f5c\u8005: \u00a7bTiXYA2357 \u00a7f& \u00a7dPHEyeji");
        Utils.checkServer();
        this.getServer().getPluginManager().registerEvents((Listener)new EventsListener(), (Plugin)this);
        this.getServer().getCommandMap().register(Configs.cmd, (Command)new CloudBlacksCommand(Configs.cmd));
        Main.Delayed(() -> {
            this.getLogger().info("\u00a76\u672c\u673aMAC\u5730\u5740: " + Utils.getMacAddress());
            try {
                HttpResponse<String> response = Utils.getHttpURLResponse(Map.of("token", Configs.getToken(), "mac", Utils.getMacAddress()), "https://uniteban.mcwaf.cn/innerapi.php");
                switch (response.statusCode()) {
                    case 200: {
                        if (Configs.debugMode) {
                            nks.getLogger().debug("API\u8bf7\u6c42\u6210\u529f");
                        }
                        break;
                    }
                    case 403: {
                        nks.getLogger().warning("\u4e0a\u4f20\u5931\u8d25, \u672a\u83b7\u53d6\u4e0a\u4f20\u6743\u9650\n\u00a7r\n\u00a7e\u5982\u679c\u60a8\u4e5f\u60f3\u4e3a\u8054\u5408\u5c01\u7981\u505a\u51fa\u8d21\u732e, \u6b22\u8fce\u524d\u5f80\u7f51\u7ad9\u00a76 https://uniteban.mcwaf.cn \u00a7e\u7533\u8bf7\u6743\u9650\n\u00a7r\n");
                        break;
                    }
                    default: {
                        nks.getLogger().error("\u4e0a\u4f20\u5931\u8d25, \u72b6\u6001\u7801: " + response.statusCode());
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().error("\u8bf7\u6c42\u5931\u8d25: " + e.getMessage());
            }
        }, 100, true);
    }

    public void onLoad() {
        ConfigPath = this.getDataFolder().getPath();
        main = this;
        Configs.initLoad();
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelAllTasks();
    }

    public static void Delayed(final Runnable logic, int time, boolean async) {
        nks.getScheduler().scheduleDelayedTask(new Task(){

            public void onRun(int i) {
                logic.run();
            }
        }, time, async);
    }

    public static String getConfigPath() {
        return ConfigPath;
    }

    public static Main getMain() {
        return main;
    }

    static {
        nks = Server.getInstance();
    }
}

