/*
 * Decompiled with CFR 0.152.
 */
package Org.UniteBan_Nukkit;

import Org.UniteBan_Nukkit.Configs;
import Org.UniteBan_Nukkit.UI.Form_Custom;
import Org.UniteBan_Nukkit.UI.MenuChest;
import Org.UniteBan_Nukkit.Utils;
import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.form.element.Element;
import cn.nukkit.form.element.ElementDropdown;
import cn.nukkit.form.element.ElementInput;
import cn.nukkit.form.element.ElementLabel;
import cn.nukkit.form.element.ElementStepSlider;
import cn.nukkit.form.element.ElementToggle;
import cn.nukkit.item.Item;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public final class FormWindows {
    private static final HashMap<String, Long> reportCD = new HashMap();

    private FormWindows() {
    }

    public static void formBannedPlayer(Player p) {
        if (FormWindows.closeUI(p)) {
            return;
        }
        int lv = Configs.getPlayerMangentLevel(p);
        Form_Custom form = new Form_Custom("\u00a7d\u5c01\u7981\u83dc\u5355");
        form.add("tips", (Element)new ElementLabel(Configs.getFormBannedUITips().replace("{p}", Utils.getPlayerName(p)).replace("{lv}", "" + lv)));
        form.add("tg", (Element)new ElementDropdown("\u00a7f\u5c01\u7981\u5bf9\u8c61", Utils.getLowManetLevelPlayerNames(p)));
        form.add("dpt", (Element)new ElementDropdown("\u00a7f\u5c01\u7981\u65f6\u95f4", new ArrayList<String>(List.of("1\u5929", "3\u5929", "7\u5929", "15\u5929", "30\u5929", "\u6c38\u4e45"))));
        form.add("dpt2", (Element)new ElementInput("\u00a7f\u5c01\u7981\u65f6\u95f4(\u7559\u7a7a\u542f\u7528\u4e0a\u65b9\u9009\u62e9)", "\u8bf7\u8f93\u5165\u5c01\u7981\u65f6\u95f4(\u79d2)"));
        form.add("reason", (Element)new ElementDropdown("\u00a7f\u5c01\u7981\u539f\u56e0", Configs.getFormBannedUIReason()));
        form.add("reason2", (Element)new ElementInput("\u00a7f\u5c01\u7981\u539f\u56e0(\u7559\u7a7a\u542f\u7528\u4e0a\u65b9\u9009\u62e9)", "\u8bf7\u8f93\u5165\u5c01\u7981\u539f\u56e0"));
        form.add("note", (Element)new ElementInput("\u00a7f\u5c01\u7981\u5907\u6ce8", "\u8bf7\u8f93\u5165\u5c01\u7981\u5907\u6ce8(\u53ef\u9009)"));
        if (p.isOp()) {
            form.add("tips", (Element)new ElementLabel("\u00a7f\u00a7l\u63d0\u793a: \u5728\u4e0a\u4f20\u524d\u8bf7\u5148\u68c0\u67e5\u662f\u5426\u62e5\u6709\u4e0a\u4f20\u6743\u9650\n\u8be5\u529f\u80fd\u4ec5\u4f5c\u4e3a\u6700\u7ec8\u624b\u6bb5\u4f7f\u7528,\u6ee5\u7528\u6b64\u529f\u80fd\u60a8\u5c06\u53ef\u80fd\u5931\u53bb\u6743\u9650\n\u8bf7\u5728\u4e0a\u4f20\u524d\u51c6\u5907\u597d\u8db3\u591f\u7684\u8bc1\u636e\n\u4e00\u822c\u7684\u8fdd\u89c4\u6216\u8a00\u8bed\u51b2\u7a81\u4e0d\u5efa\u8bae\u4e0a\u4f20\n\u4e0a\u4f20\u6210\u529f\u540e\u4ec5\u5141\u8bb8\u4eba\u5de5\u64cd\u4f5c\u89e3\u9664\n"));
            form.add("bc", (Element)new ElementToggle("\u00a7f\u4e0a\u4f20\u4e91\u9ed1", false));
        }
        form.setSubmit(() -> {
            int time;
            Player tg = Utils.getPlayerTarget((String)form.getRes("tg"));
            if (form.getRes("dpt2").toString().isEmpty()) {
                time = switch (form.getRes("dpt").toString()) {
                    case "1\u5929" -> 86400;
                    case "3\u5929" -> 259200;
                    case "7\u5929" -> 604800;
                    case "15\u5929" -> 1296000;
                    case "30\u5929" -> 2592000;
                    default -> -1;
                };
            } else {
                try {
                    time = Integer.parseInt((String)form.getRes("dpt2"));
                }
                catch (NumberFormatException e) {
                    p.sendMessage(Configs.PT + "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u65f6\u95f4(\u6574\u6570,\u79d2)");
                    return;
                }
            }
            boolean ubc = p.isOp() && (Boolean)form.getRes("bc") != false;
            String reason = form.getRes("reason2").toString().isEmpty() ? form.getRes("reason").toString() : form.getRes("reason2").toString();
            String note = form.getRes("note").toString();
            Object s = note.isEmpty() ? "" : " \u5907\u6ce8: " + note;
            String workNo = Utils.genRandomTickets();
            String strTime = time == -1 ? "\u6c38\u4e45" : Utils.secondsToDateTime(time);
            String days = time == -1 ? "\u6c38\u4e45" : Utils.convertSecondsToTime(time);
            String log = "[" + new SimpleDateFormat("HH:mm:ss") + "] " + (String)(p.isOp() ? "\u64cd\u4f5c\u5458" : lv + "\u7ea7\u534f\u7ba1") + Utils.getPlayerName(p) + " \u5c06\u73a9\u5bb6 " + Utils.getPlayerName(tg) + " \u5c01\u7981\u81f3 " + strTime + "(" + days + ")  \u539f\u56e0: " + reason + (String)s;
            String subLog = "[" + new SimpleDateFormat("yy-MM-dd HH:mm:ss") + "] \u56e0 " + reason + " \u88ab " + (String)(p.isOp() ? "\u64cd\u4f5c\u5458" : lv + "\u7ea7\u534f\u7ba1") + Utils.getPlayerName(p) + " \u5c01\u7981\u81f3 " + strTime + "(" + days + ") " + (String)s + " \u5de5\u5355: " + workNo;
            Configs.addMangentOperatorsLog(log);
            Configs.addPlayerBannedHistory("" + tg.getUniqueId(), subLog);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("\u5c01\u7981\u73a9\u5bb6", Utils.getPlayerName(tg));
            map.put("\u5c01\u7981\u65f6\u95f4", strTime);
            map.put("\u5c01\u7981\u539f\u56e0", reason);
            map.put("\u5c01\u7981\u5907\u6ce8", note);
            map.put("\u5c01\u7981\u5de5\u5355", workNo);
            Configs.addBannedPlayers("" + tg.getUniqueId(), map);
            if (ubc) {
                Utils.updateToCloudBlackList(tg.getName(), reason, true, (CommandSender)p);
            }
            tg.kick("\u00a7c\u4f60\u5df2\u88ab\u88ab\u5c01\u7981\u81f3\n" + strTime + "\n\u5c01\u7981\u539f\u56e0: \n" + reason + "\n\u00a7e\u7533\u8bc9\u5de5\u5355: \n" + workNo + "\n\u5907\u6ce8:\n" + Configs.getBannedNote(), false);
        });
        form.asyncShow(p);
    }

    public static void formKickPlayer(Player p) {
        if (FormWindows.closeUI(p)) {
            return;
        }
        Form_Custom form = new Form_Custom("\u00a7d\u8e22\u51fa\u73a9\u5bb6");
        form.add("pls", (Element)new ElementDropdown("\u00a7a\u8bf7\u9009\u62e9\u73a9\u5bb6", Utils.getLowManetLevelPlayerNames(p)));
        form.add("reason", (Element)new ElementInput("\u00a7a\u8bf7\u8f93\u5165\u8e22\u51fa\u7406\u7531"));
        form.setSubmit(() -> {
            String playerName = form.getRes("pls").toString();
            Player target = Utils.getPlayerTarget(playerName);
            String reason = form.getRes("reason").toString();
            target.kick(reason.isEmpty() ? "\u6b63\u5728\u4ece\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5" : reason, false);
            p.sendMessage(Configs.PT + "\u5df2\u8e22\u51fa\u73a9\u5bb6 " + playerName);
            int lv = Configs.getPlayerMangentLevel(p);
            SimpleDateFormat hour = new SimpleDateFormat("HH:mm:ss");
            Object s = reason.isEmpty() ? "" : "\u539f\u56e0: " + reason;
            String log = "[" + hour + "] " + (String)(p.isOp() ? "\u64cd\u4f5c\u5458" : lv + "\u7ea7\u534f\u7ba1") + Utils.getPlayerName(p) + " \u5c06\u73a9\u5bb6 " + Utils.getPlayerName(target) + " \u8e22\u51fa\u4e86\u6e38\u620f " + (String)s;
            String subLog = "[" + new SimpleDateFormat("yy-MM-dd HH:mm:ss") + "] \u88ab " + (String)(p.isOp() ? "\u64cd\u4f5c\u5458" : lv + "\u7ea7\u534f\u7ba1") + Utils.getPlayerName(p) + " \u8e22\u51fa\u4e86\u6e38\u620f" + (String)s;
            Configs.addMangentOperatorsLog(log);
            Configs.addPlayerBannedHistory("" + target.getUniqueId(), subLog);
        });
        form.asyncShow(p);
    }

    public static void formWarnPlayer(Player p) {
        if (FormWindows.closeUI(p)) {
            return;
        }
        Form_Custom form = new Form_Custom("\u00a7d\u8b66\u544a\u73a9\u5bb6");
        form.add("pls", (Element)new ElementDropdown("\u00a7a\u8bf7\u9009\u62e9\u73a9\u5bb6", Utils.getLowManetLevelPlayerNames(p)));
        form.add("text", (Element)new ElementInput("\u00a7a\u8bf7\u8f93\u5165\u8b66\u544a\u5185\u5bb9"));
        form.setSubmit(() -> {
            Player player = Utils.getPlayerTarget((String)form.getRes("pls"));
            String text = form.getRes("text").toString();
            if (text.isEmpty()) {
                p.sendMessage(Configs.PT + "\u8bf7\u8f93\u5165\u8b66\u544a\u5185\u5bb9");
            } else {
                p.sendMessage(Configs.PT + "\u5df2\u7ed9\u73a9\u5bb6" + player.getName() + "\u53d1\u9001\u8b66\u544a: " + text);
                player.sendMessage(Configs.PT + "\u4f60\u6536\u5230\u4e86\u8b66\u544a: \u00a7l" + text);
                player.sendTitle("\u00a7c\u4f60\u5df2\u88ab\u7ba1\u7406\u5458\u8b66\u544a", text, 5, 20, 5);
            }
        });
        form.asyncShow(p);
    }

    public static void formSetPlayerBanInfo(Player p) {
        HashMap<String, HashMap<String, String>> all = Configs.getBannedPlayers();
        Set<Map.Entry<String, HashMap<String, String>>> infoMap = all.entrySet();
        ArrayList list = new ArrayList();
        infoMap.forEach(entry -> {
            String name = ((HashMap)entry.getValue()).getOrDefault("\u5c01\u7981\u73a9\u5bb6", "");
            if (!name.isEmpty()) {
                list.add(name);
            }
        });
        if (list.isEmpty()) {
            p.sendMessage(Configs.PT + "\u6ca1\u6709\u88ab\u5c01\u7981\u7684\u73a9\u5bb6");
            return;
        }
        Form_Custom form = new Form_Custom("\u00a7d\u8bbe\u7f6e\u73a9\u5bb6\u5c01\u7981\u65f6\u95f4");
        form.add("pls", (Element)new ElementDropdown("\u00a7a\u8bf7\u9009\u62e9\u73a9\u5bb6", list));
        form.add("type", (Element)new ElementStepSlider("\u00a7a\u8bf7\u9009\u62e9\u66f4\u6539\u7c7b\u578b", List.of("\u589e\u52a0", "\u51cf\u5c11", "\u8bbe\u7f6e")));
        form.add("time", (Element)new ElementInput("\u00a7a\u8bf7\u8f93\u5165\u65f6\u95f4(\u79d2)"));
        form.setSubmit(() -> {
            String playerName = form.getRes("pls").toString();
            int time = 0;
            try {
                time = Integer.parseInt((String)form.getRes("time"));
            }
            catch (NumberFormatException e) {
                p.sendMessage(Configs.PT + "\u8bf7\u8f93\u5165\u6b63\u786e\u65f6\u95f4(\u6574\u6570,\u79d2)");
                return;
            }
            AtomicReference type = new AtomicReference();
            int finalTime = time;
            infoMap.forEach(entry -> {
                if (((HashMap)entry.getValue()).getOrDefault("\u5c01\u7981\u73a9\u5bb6", "").equals(playerName)) {
                    HashMap map = (HashMap)entry.getValue();
                    String strTime = map.getOrDefault("\u5c01\u7981\u65f6\u95f4", "");
                    if (strTime.equals("\u6c38\u4e45") && !form.getRes("type").toString().equals("\u8bbe\u7f6e")) {
                        p.sendMessage(Configs.PT + "\u73a9\u5bb6 " + playerName + " \u5df2\u88ab\u6c38\u4e45\u5c01\u7981,\u65e0\u6cd5\u589e\u51cf\u65f6\u95f4");
                        return;
                    }
                    switch (form.getRes("type").toString()) {
                        case "\u589e\u52a0": {
                            type.set("\u589e\u52a0");
                            map.put("\u5c01\u7981\u65f6\u95f4", Utils.setDateTime(Utils.TimeType.ADD, strTime, finalTime));
                            break;
                        }
                        case "\u51cf\u5c11": {
                            type.set("\u51cf\u5c11");
                            map.put("\u5c01\u7981\u65f6\u95f4", Utils.setDateTime(Utils.TimeType.DEL, strTime, finalTime));
                            break;
                        }
                        case "\u8bbe\u7f6e": {
                            type.set("\u8bbe\u7f6e");
                            map.put("\u5c01\u7981\u65f6\u95f4", Utils.setDateTime(Utils.TimeType.SET, strTime, finalTime));
                        }
                    }
                    all.put((String)entry.getKey(), map);
                    Configs.setConfig("BannedPlayers", "\u5c01\u7981\u73a9\u5bb6", all);
                }
            });
            p.sendMessage(Configs.PT + "\u5df2" + (String)type.get() + "\u73a9\u5bb6 " + playerName + " \u7684\u5c01\u7981\u65f6\u95f4: " + time);
        });
        form.asyncShow(p);
    }

    public static void formQueryPlayerHistory(Player p, int offset, int limit) {
        HashMap<String, List<String>> all = Configs.getPlayerBannedHistory();
        ArrayList<String> playerList = new ArrayList<String>(Configs.playerDates.keySet());
        if (all.isEmpty()) {
            p.sendMessage(Configs.PT + "\u6682\u65e0\u6709\u8fdd\u89c4\u8bb0\u5f55!");
            return;
        }
        MenuChest menu = new MenuChest("\u00a7d\u8fdd\u89c4\u8bb0\u5f55\u67e5\u8be2", true, true);
        for (int i = offset; i < limit && i < playerList.size(); ++i) {
            String playerName = playerList.get(i);
            menu.add(i + 1, Utils.ChestMenuTo(Item.get((int)397), 1, 3, playerName), () -> {
                if (!all.containsKey((String)Configs.playerDates.get(playerName).get("UUID"))) {
                    p.sendMessage(Configs.PT + "\u73a9\u5bb6 " + playerName + " \u6682\u65e0\u8fdd\u89c4\u8bb0\u5f55!");
                } else {
                    List info = (List)all.get((String)Configs.playerDates.get(playerName).get("UUID"));
                    Form_Custom form = new Form_Custom("\u00a7a" + playerName + " \u00a7d\u7684\u8fdd\u89c4\u8bb0\u5f55\u67e5\u8be2");
                    StringBuilder text = new StringBuilder();
                    info.forEach(s -> text.append("\n").append((String)s).append("\n"));
                    form.add("", (Element)new ElementLabel(text.toString().trim()));
                    form.asyncShow(p);
                }
            });
        }
        if (offset > 0) {
            menu.add(19, Utils.ChestMenuTo(Item.get((int)262), 1, 0, "\u4e0a\u4e00\u9875"), () -> FormWindows.formQueryPlayerHistory(p, offset - limit, limit));
        }
        if (offset + limit < all.size()) {
            menu.add(27, Utils.ChestMenuTo(Item.get((int)262), 1, 0, "\u4e0b\u4e00\u9875"), () -> FormWindows.formQueryPlayerHistory(p, offset + limit, limit));
        }
        menu.show(p);
    }

    public static void formReportPlayer(Player p) {
        if (Utils.getAllReportPlayers(p).isEmpty()) {
            p.sendMessage(Configs.PT + "\u6ca1\u6709\u7b26\u5408\u4e3e\u62a5\u6761\u4ef6\u7684\u73a9\u5bb6");
            return;
        }
        reportCD.values().removeIf(time -> System.currentTimeMillis() - time > 30000L);
        if (reportCD.containsKey(p.getName())) {
            p.sendMessage(Configs.PT + "\u8bf7\u5728 " + (System.currentTimeMillis() - reportCD.getOrDefault(p.getName(), 0L) / 1000L) + " \u79d2\u540e\u91cd\u8bd5");
            return;
        }
        reportCD.put(p.getName(), System.currentTimeMillis());
        Form_Custom form = new Form_Custom("\u00a7d\u4e3e\u62a5\u73a9\u5bb6");
        form.add("pl", (Element)new ElementDropdown("\u00a7f\u8bf7\u9009\u62e9\u8981\u4e3e\u62a5\u7684\u73a9\u5bb6", Utils.getAllReportPlayers(p)));
        form.add("reason", (Element)new ElementDropdown("\u00a7f\u8bf7\u9009\u62e9\u4e3e\u62a5\u7406\u7531", Configs.getFormBannedUIReason()));
        form.add("reason2", (Element)new ElementInput("\u00a7f\u8bf7\u8f93\u5165\u4e3e\u62a5\u7406\u7531(\u7559\u7a7a\u542f\u7528\u4e0a\u65b9\u529f\u80fd)"));
        form.add("note", (Element)new ElementInput("\u00a7f\u8bf7\u8f93\u5165\u5907\u6ce8(\u53ef\u9009)"));
        form.add("any", (Element)new ElementToggle("\u00a7f\u662f\u5426\u533f\u540d\u4e3e\u62a5", false));
        form.setSubmit(() -> {
            Player player = (Player)form.getRes("any");
            String reason = form.getRes("reason2").toString().isEmpty() ? (String)form.getRes("reason") : (String)form.getRes("reason2");
            String note = form.getRes("note").toString();
            boolean any = (Boolean)form.getRes("any");
            HashMap<String, HashMap<String, String>> all = Configs.getReportPlayers();
            if (all.containsKey("" + player.getUniqueId())) {
                int count = Integer.parseInt(Configs.getReportInfoByPlayer("" + player.getUniqueId(), "\u4e3e\u62a5\u6b21\u6570"));
                HashMap<String, String> newMap = new HashMap<String, String>();
                newMap.put("\u4e3e\u62a5\u6b21\u6570", "" + (count + 1));
                newMap.put("\u6700\u540e\u4e3e\u62a5\u65f6\u95f4", Utils.getNowTime());
                newMap.put("\u73a9\u5bb6\u540d\u79f0", Utils.getPlayerName(player));
                newMap.put("\u4e3e\u62a5\u539f\u56e0", reason);
                newMap.put("\u4e3e\u62a5\u5907\u6ce8", note);
                newMap.put("\u4e3e\u62a5\u4eba", any ? "\u533f\u540d" : Utils.getPlayerName(p));
                Configs.addReportPlayers("" + player.getUniqueId(), newMap);
            }
            p.sendMessage(Configs.PT + "\u4f60\u5df2\u6210\u529f" + (any ? "\u533f\u540d" : "") + "\u4e3e\u62a5\u73a9\u5bb6 " + Utils.getPlayerName(player) + " !\u8bf7\u8010\u5fc3\u7b49\u5f85\u5904\u7406.\n\u611f\u8c22\u4f60\u4e3a\u7eff\u8272\u6e38\u620f\u73af\u5883\u505a\u51fa\u7684\u8d21\u732e!");
        });
        form.asyncShow(p);
    }

    public static void formHandleReportPlayer(Player p, int offset, int limit) {
        HashMap<String, HashMap<String, String>> all = Configs.getReportPlayers();
        Set<Map.Entry<String, HashMap<String, String>>> infoMap = all.entrySet();
        ArrayList list = new ArrayList();
        infoMap.forEach(entry -> {
            String name = (String)((HashMap)entry.getValue()).get("\u73a9\u5bb6\u540d\u79f0");
            if (!name.isEmpty()) {
                list.add(name);
            }
        });
        if (list.isEmpty()) {
            p.sendMessage(Configs.PT + "\u6ca1\u6709\u5f85\u5904\u7406\u7684\u4e3e\u62a5");
            return;
        }
        MenuChest menu = new MenuChest("\u00a7d\u5904\u7406\u4e3e\u62a5\u73a9\u5bb6", true, true);
        for (int i = offset; i < limit && i < list.size(); ++i) {
            String playerName = (String)list.get(i);
            menu.add(i + 1, Utils.ChestMenuTo(Item.get((int)397), 1, 3, playerName), () -> {
                if (!all.containsKey((String)Configs.playerDates.get(playerName).get("UUID"))) {
                    p.sendMessage(Configs.PT + "\u73a9\u5bb6 " + playerName + " \u6682\u65e0\u8fdd\u89c4\u8bb0\u5f55!");
                } else {
                    HashMap info = (HashMap)all.get((String)Configs.playerDates.get(playerName).get("UUID"));
                    Form_Custom form = new Form_Custom("\u00a7a" + playerName + " \u00a7d\u7684\u4e3e\u62a5\u7ed3\u679c");
                    String count = info.getOrDefault("\u4e3e\u62a5\u6b21\u6570", "0");
                    String lastTime = info.getOrDefault("\u6700\u540e\u4e3e\u62a5\u65f6\u95f4", "null");
                    String reason = info.getOrDefault("\u4e3e\u62a5\u539f\u56e0", "null");
                    String note = info.getOrDefault("\u4e3e\u62a5\u5907\u6ce8", "null");
                    String any = info.getOrDefault("\u4e3e\u62a5\u4eba", "\u533f\u540d");
                    String text = "\n\u4e3e\u62a5\u6b21\u6570: " + count + "\n\u4e3e\u62a5\u539f\u56e0: " + reason + "\n\u4e3e\u62a5\u5907\u6ce8: " + note + "\n\u4e3e\u62a5\u4eba: " + any + "\n\u6700\u540e\u4e3e\u62a5\u65f6\u95f4: " + lastTime;
                    form.add("", (Element)new ElementLabel(text.trim()));
                    form.add("", (Element)new ElementLabel("\u00a7d\u8bf7\u8df3\u8f6cUI\u8fdb\u884c\u5904\u7406"));
                    form.add("del", (Element)new ElementToggle("\u00a7f\u5220\u9664\u6b64\u4e3e\u62a5(\u8bb0\u5f55\u5904\u7406\u65e5\u5fd7)", false));
                    form.setSubmit(() -> {
                        boolean ok = (Boolean)form.getRes("del");
                        if (ok) {
                            Configs.delReportPlayers(Utils.decrypt((String)Configs.playerDates.get(playerName).get("UUID")));
                            String log = "[" + new SimpleDateFormat("HH:mm:ss") + "] " + (String)(p.isOp() ? "\u64cd\u4f5c\u5458" : Utils.getLowManetLevelPlayerNames(p) + "\u7ea7\u534f\u7ba1") + Utils.getPlayerName(p) + " \u5bf9\u73a9\u5bb6 " + playerName + " \u7684\u88ab\u4e3e\u62a5\u7ed3\u679c\u8fdb\u884c\u4e86\u5904\u7406";
                            Configs.addMangentOperatorsLog(log);
                            FormWindows.formBannedPlayer(p);
                        }
                    });
                    form.asyncShow(p);
                }
            });
        }
        if (offset > 0) {
            menu.add(19, Utils.ChestMenuTo(Item.get((int)262), 1, 0, "\u4e0a\u4e00\u9875"), () -> FormWindows.formHandleReportPlayer(p, offset - limit, limit));
        }
        if (offset + limit < all.size()) {
            menu.add(27, Utils.ChestMenuTo(Item.get((int)262), 1, 0, "\u4e0b\u4e00\u9875"), () -> FormWindows.formHandleReportPlayer(p, offset + limit, limit));
        }
        menu.show(p);
    }

    private static boolean closeUI(Player p) {
        if (Utils.getLowManetLevelPlayerNames(p).isEmpty()) {
            p.sendMessage(Configs.PT + "\u6ca1\u6709\u6743\u9650\u5185\u53ef\u9009\u4e2d\u7684\u73a9\u5bb6");
            return true;
        }
        return false;
    }
}

