/*
 * Decompiled with CFR 0.152.
 */
package Org.UniteBan_Nukkit;

import Org.UniteBan_Nukkit.Configs;
import Org.UniteBan_Nukkit.Main;
import Org.UniteBan_Nukkit.UI.FakeInventoryChest;
import Org.UniteBan_Nukkit.Utils;
import cn.nukkit.Player;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.inventory.InventoryTransactionEvent;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.player.PlayerLocallyInitializedEvent;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EventsListener
implements Listener {
    @EventHandler
    protected void onPlayerLogin(PlayerLocallyInitializedEvent e) {
        Player player = e.getPlayer();
        String playerName = player.getName();
        Utils.Delayed(() -> {
            String strTime;
            String uuid = "" + player.getUniqueId();
            String xuid = player.getLoginChainData().getXUID();
            String ip = player.getAddress();
            String clientId = player.getLoginChainData().getDeviceId();
            if (!Configs.playerDates.containsKey(playerName)) {
                HashMap<String, String> newMap = new HashMap<String, String>();
                newMap.put("UUID", Utils.encrypt(uuid));
                newMap.put("XUID", Utils.encrypt(xuid));
                newMap.put("IP", Utils.encrypt(ip));
                newMap.put("ClientID", Utils.encrypt(clientId));
                Configs.playerDates.put(playerName, newMap);
                Configs.setConfig("Playerdatas", "\u73a9\u5bb6\u6570\u636e", Configs.playerDates);
            }
            if (!(strTime = Configs.getBannedInfoByPlayer("" + player.getUniqueId(), "\u5c01\u7981\u65f6\u95f4")).isEmpty()) {
                String strReason = Configs.getBannedInfoByPlayer("" + player.getUniqueId(), "\u5c01\u7981\u539f\u56e0");
                String strTickets = Configs.getBannedInfoByPlayer("" + player.getUniqueId(), "\u5c01\u7981\u5de5\u5355");
                long intTTime = strTime.equals("\u6c38\u4e45") ? 1L : Utils.secondsLeft(strTime);
                String reason = "\u00a7c\u4f60\u5df2\u88ab\u88ab\u5c01\u7981\u81f3\n" + strTime + "\n\u5c01\u7981\u539f\u56e0: \n" + strReason + "\n\u00a7e\u7533\u8bc9\u5de5\u5355: \n" + strTickets + "\n\u5907\u6ce8:\n" + Configs.getBannedNote();
                if (intTTime > 0L) {
                    player.kick(reason, false);
                } else {
                    Configs.delBannedPlayers("" + player.getUniqueId());
                }
            }
            if (!Configs.getIgnCheckPlayers().contains(playerName)) {
                Utils.checkCloudBan(playerName, xuid, uuid, clientId, ip);
            }
        }, 1, true);
    }

    @EventHandler
    protected void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent e) {
        Player player = e.getPlayer();
        String cmd = e.getMessage().toLowerCase().trim();
        int ml = Configs.getPlayerMangentLevel(player);
        if (ml > 0) {
            HashMap mi = Configs.getCoMangentLevels().getOrDefault("" + ml, new HashMap());
            List cmds = mi.getOrDefault("\u6743\u9650\u6307\u4ee4", new ArrayList());
            cmds.forEach(c -> {
                if (cmd.startsWith(c + " ")) {
                    e.setCancelled();
                    Utils.asOPCmd(player, cmd);
                }
            });
        }
    }

    @EventHandler
    protected void onPlayerChat(PlayerChatEvent e) {
        Player player = e.getPlayer();
        String msg = e.getMessage();
        if ((player.isOp() || Configs.getPlayerMangentLevel(player) > 0) && msg.startsWith(Configs.getMangentMsgChatPT())) {
            e.setCancelled();
            String out = "\u00a7b[\u00a7d\u7ba1\u7406\u9891\u9053\u00a7b]\u00a7e " + Utils.getPlayerName(player) + " \u00a77->\u00a7f " + msg.replace(Configs.getMangentMsgChatPT(), "");
            Main.nks.getLogger().info(out);
            Main.nks.getOnlinePlayers().values().forEach(target -> {
                if (target.isOp() || Configs.getPlayerMangentLevel(target) > 0) {
                    target.sendMessage(out);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onInventoryTransaction(InventoryTransactionEvent event) {
        event.getTransaction().getActions().forEach(action -> {
            SlotChangeAction slotChange;
            Inventory patt3862$temp;
            if (action instanceof SlotChangeAction && (patt3862$temp = (slotChange = (SlotChangeAction)action).getInventory()) instanceof FakeInventoryChest) {
                FakeInventoryChest inventory = (FakeInventoryChest)patt3862$temp;
                if (inventory.isBag()) {
                    return;
                }
                inventory.setEvent(event);
                int slot = slotChange.getSlot();
                if (inventory.getSlots().contains(slot)) {
                    Utils.Delayed(() -> inventory.getRs().get(slot).run(), 2, inventory.isAsync());
                    if (inventory.isAutoClose()) {
                        inventory.close(inventory.getPlayer());
                    }
                }
                event.setCancelled(true);
            }
        });
    }
}

